/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetFactory;
import oracle.sql.CharacterSetFactoryDefault;
import oracle.sql.CharacterSetFactoryThin;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.CharacterConverterFactoryOGS;

public abstract class CharacterSet {
    public static final short DEFAULT_CHARSET = -1;
    public static final short ASCII_CHARSET = 1;
    public static final short ISO_LATIN_1_CHARSET = 31;
    public static final short UNICODE_1_CHARSET = 870;
    public static final short US7ASCII_CHARSET = 1;
    public static final short WE8DEC_CHARSET = 2;
    public static final short WE8HP_CHARSET = 3;
    public static final short US8PC437_CHARSET = 4;
    public static final short WE8EBCDIC37_CHARSET = 5;
    public static final short WE8EBCDIC500_CHARSET = 6;
    public static final short WE8EBCDIC285_CHARSET = 8;
    public static final short WE8PC850_CHARSET = 10;
    public static final short D7DEC_CHARSET = 11;
    public static final short F7DEC_CHARSET = 12;
    public static final short S7DEC_CHARSET = 13;
    public static final short E7DEC_CHARSET = 14;
    public static final short SF7ASCII_CHARSET = 15;
    public static final short NDK7DEC_CHARSET = 16;
    public static final short I7DEC_CHARSET = 17;
    public static final short NL7DEC_CHARSET = 18;
    public static final short CH7DEC_CHARSET = 19;
    public static final short YUG7ASCII_CHARSET = 20;
    public static final short SF7DEC_CHARSET = 21;
    public static final short TR7DEC_CHARSET = 22;
    public static final short IW7IS960_CHARSET = 23;
    public static final short IN8ISCII_CHARSET = 25;
    public static final short WE8ISO8859P1_CHARSET = 31;
    public static final short EE8ISO8859P2_CHARSET = 32;
    public static final short SE8ISO8859P3_CHARSET = 33;
    public static final short NEE8ISO8859P4_CHARSET = 34;
    public static final short CL8ISO8859P5_CHARSET = 35;
    public static final short AR8ISO8859P6_CHARSET = 36;
    public static final short EL8ISO8859P7_CHARSET = 37;
    public static final short IW8ISO8859P8_CHARSET = 38;
    public static final short WE8ISO8859P9_CHARSET = 39;
    public static final short NE8ISO8859P10_CHARSET = 40;
    public static final short TH8TISASCII_CHARSET = 41;
    public static final short TH8TISEBCDIC_CHARSET = 42;
    public static final short BN8BSCII_CHARSET = 43;
    public static final short VN8VN3_CHARSET = 44;
    public static final short VN8MSWIN1258_CHARSET = 45;
    public static final short WE8ISO8859P15_CHARSET = 46;
    public static final short WE8NEXTSTEP_CHARSET = 50;
    public static final short AR8ASMO708PLUS_CHARSET = 61;
    public static final short AR8EBCDICX_CHARSET = 70;
    public static final short AR8XBASIC_CHARSET = 72;
    public static final short EL8DEC_CHARSET = 81;
    public static final short TR8DEC_CHARSET = 82;
    public static final short WE8EBCDIC37C_CHARSET = 90;
    public static final short WE8EBCDIC500C_CHARSET = 91;
    public static final short IW8EBCDIC424_CHARSET = 92;
    public static final short TR8EBCDIC1026_CHARSET = 93;
    public static final short WE8EBCDIC871_CHARSET = 94;
    public static final short WE8EBCDIC284_CHARSET = 95;
    public static final short WE8EBCDIC1047_CHARSET = 96;
    public static final short EEC8EUROASCI_CHARSET = 110;
    public static final short EEC8EUROPA3_CHARSET = 113;
    public static final short LA8PASSPORT_CHARSET = 114;
    public static final short BG8PC437S_CHARSET = 140;
    public static final short EE8PC852_CHARSET = 150;
    public static final short RU8PC866_CHARSET = 152;
    public static final short RU8BESTA_CHARSET = 153;
    public static final short IW8PC1507_CHARSET = 154;
    public static final short RU8PC855_CHARSET = 155;
    public static final short TR8PC857_CHARSET = 156;
    public static final short CL8MACCYRILLIC_CHARSET = 158;
    public static final short CL8MACCYRILLICS_CHARSET = 159;
    public static final short WE8PC860_CHARSET = 160;
    public static final short IS8PC861_CHARSET = 161;
    public static final short EE8MACCES_CHARSET = 162;
    public static final short EE8MACCROATIANS_CHARSET = 163;
    public static final short TR8MACTURKISHS_CHARSET = 164;
    public static final short IS8MACICELANDICS_CHARSET = 165;
    public static final short EL8MACGREEKS_CHARSET = 166;
    public static final short IW8MACHEBREWS_CHARSET = 167;
    public static final short EE8MSWIN1250_CHARSET = 170;
    public static final short CL8MSWIN1251_CHARSET = 171;
    public static final short ET8MSWIN923_CHARSET = 172;
    public static final short BG8MSWIN_CHARSET = 173;
    public static final short EL8MSWIN1253_CHARSET = 174;
    public static final short IW8MSWIN1255_CHARSET = 175;
    public static final short LT8MSWIN921_CHARSET = 176;
    public static final short TR8MSWIN1254_CHARSET = 177;
    public static final short WE8MSWIN1252_CHARSET = 178;
    public static final short BLT8MSWIN1257_CHARSET = 179;
    public static final short D8EBCDIC273_CHARSET = 180;
    public static final short I8EBCDIC280_CHARSET = 181;
    public static final short DK8EBCDIC277_CHARSET = 182;
    public static final short S8EBCDIC278_CHARSET = 183;
    public static final short EE8EBCDIC870_CHARSET = 184;
    public static final short CL8EBCDIC1025_CHARSET = 185;
    public static final short F8EBCDIC297_CHARSET = 186;
    public static final short IW8EBCDIC1086_CHARSET = 187;
    public static final short CL8EBCDIC1025X_CHARSET = 188;
    public static final short N8PC865_CHARSET = 190;
    public static final short BLT8CP921_CHARSET = 191;
    public static final short LV8PC1117_CHARSET = 192;
    public static final short LV8PC8LR_CHARSET = 193;
    public static final short BLT8EBCDIC1112_CHARSET = 194;
    public static final short LV8RST104090_CHARSET = 195;
    public static final short CL8KOI8R_CHARSET = 196;
    public static final short BLT8PC775_CHARSET = 197;
    public static final short F7SIEMENS9780X_CHARSET = 201;
    public static final short E7SIEMENS9780X_CHARSET = 202;
    public static final short S7SIEMENS9780X_CHARSET = 203;
    public static final short DK7SIEMENS9780X_CHARSET = 204;
    public static final short N7SIEMENS9780X_CHARSET = 205;
    public static final short I7SIEMENS9780X_CHARSET = 206;
    public static final short D7SIEMENS9780X_CHARSET = 207;
    public static final short WE8GCOS7_CHARSET = 210;
    public static final short EL8GCOS7_CHARSET = 211;
    public static final short US8BS2000_CHARSET = 221;
    public static final short D8BS2000_CHARSET = 222;
    public static final short F8BS2000_CHARSET = 223;
    public static final short E8BS2000_CHARSET = 224;
    public static final short DK8BS2000_CHARSET = 225;
    public static final short S8BS2000_CHARSET = 226;
    public static final short WE8BS2000_CHARSET = 231;
    public static final short CL8BS2000_CHARSET = 235;
    public static final short WE8BS2000L5_CHARSET = 239;
    public static final short WE8DG_CHARSET = 241;
    public static final short WE8NCR4970_CHARSET = 251;
    public static final short WE8ROMAN8_CHARSET = 261;
    public static final short EE8MACCE_CHARSET = 262;
    public static final short EE8MACCROATIAN_CHARSET = 263;
    public static final short TR8MACTURKISH_CHARSET = 264;
    public static final short IS8MACICELANDIC_CHARSET = 265;
    public static final short EL8MACGREEK_CHARSET = 266;
    public static final short IW8MACHEBREW_CHARSET = 267;
    public static final short US8ICL_CHARSET = 277;
    public static final short WE8ICL_CHARSET = 278;
    public static final short WE8ISOICLUK_CHARSET = 279;
    public static final short WE8MACROMAN8_CHARSET = 351;
    public static final short WE8MACROMAN8S_CHARSET = 352;
    public static final short TH8MACTHAI_CHARSET = 353;
    public static final short TH8MACTHAIS_CHARSET = 354;
    public static final short HU8CWI2_CHARSET = 368;
    public static final short EL8PC437S_CHARSET = 380;
    public static final short EL8EBCDIC875_CHARSET = 381;
    public static final short EL8PC737_CHARSET = 382;
    public static final short LT8PC772_CHARSET = 383;
    public static final short LT8PC774_CHARSET = 384;
    public static final short EL8PC869_CHARSET = 385;
    public static final short EL8PC851_CHARSET = 386;
    public static final short CDN8PC863_CHARSET = 390;
    public static final short HU8ABMOD_CHARSET = 401;
    public static final short AR8ASMO8X_CHARSET = 500;
    public static final short AR8NAFITHA711T_CHARSET = 504;
    public static final short AR8SAKHR707T_CHARSET = 505;
    public static final short AR8MUSSAD768T_CHARSET = 506;
    public static final short AR8ADOS710T_CHARSET = 507;
    public static final short AR8ADOS720T_CHARSET = 508;
    public static final short AR8APTEC715T_CHARSET = 509;
    public static final short AR8NAFITHA721T_CHARSET = 511;
    public static final short AR8HPARABIC8T_CHARSET = 514;
    public static final short AR8NAFITHA711_CHARSET = 554;
    public static final short AR8SAKHR707_CHARSET = 555;
    public static final short AR8MUSSAD768_CHARSET = 556;
    public static final short AR8ADOS710_CHARSET = 557;
    public static final short AR8ADOS720_CHARSET = 558;
    public static final short AR8APTEC715_CHARSET = 559;
    public static final short AR8MSAWIN_CHARSET = 560;
    public static final short AR8NAFITHA721_CHARSET = 561;
    public static final short AR8SAKHR706_CHARSET = 563;
    public static final short AR8ARABICMAC_CHARSET = 565;
    public static final short AR8ARABICMACS_CHARSET = 566;
    public static final short AR8ARABICMACT_CHARSET = 567;
    public static final short LA8ISO6937_CHARSET = 590;
    public static final short US8NOOP_CHARSET = 797;
    public static final short WE8DECTST_CHARSET = 798;
    public static final short JA16VMS_CHARSET = 829;
    public static final short JA16EUC_CHARSET = 830;
    public static final short JA16EUCYEN_CHARSET = 831;
    public static final short JA16SJIS_CHARSET = 832;
    public static final short JA16DBCS_CHARSET = 833;
    public static final short JA16SJISYEN_CHARSET = 834;
    public static final short JA16EBCDIC930_CHARSET = 835;
    public static final short JA16MACSJIS_CHARSET = 836;
    public static final short JA16EUCTILDE_CHARSET = 837;
    public static final short JA16SJISTILDE_CHARSET = 838;
    public static final short KO16KSC5601_CHARSET = 840;
    public static final short KO16DBCS_CHARSET = 842;
    public static final short KO16KSCCS_CHARSET = 845;
    public static final short KO16MSWIN949_CHARSET = 846;
    public static final short ZHS16CGB231280_CHARSET = 850;
    public static final short ZHS16MACCGB231280_CHARSET = 851;
    public static final short ZHS16GBK_CHARSET = 852;
    public static final short ZHS16DBCS_CHARSET = 853;
    public static final short ZHS32GB18030_CHARSET = 854;
    public static final short ZHT32EUC_CHARSET = 860;
    public static final short ZHT32SOPS_CHARSET = 861;
    public static final short ZHT16DBT_CHARSET = 862;
    public static final short ZHT32TRIS_CHARSET = 863;
    public static final short ZHT16DBCS_CHARSET = 864;
    public static final short ZHT16BIG5_CHARSET = 865;
    public static final short ZHT16CCDC_CHARSET = 866;
    public static final short ZHT16MSWIN950_CHARSET = 867;
    public static final short AL24UTFFSS_CHARSET = 870;
    public static final short UTF8_CHARSET = 871;
    public static final short UTFE_CHARSET = 872;
    public static final short AL32UTF8_CHARSET = 873;
    public static final short KO16TSTSET_CHARSET = 996;
    public static final short JA16TSTSET2_CHARSET = 997;
    public static final short JA16TSTSET_CHARSET = 998;
    public static final short US16TSTFIXED_CHARSET = 1001;
    public static final short AL16UTF16_CHARSET = 2000;
    public static final short AL16UTF16LE_CHARSET = 2002;
    public static final short TH8TISEBCDICS_CHARSET = 319;
    public static final short BLT8EBCDIC1112S_CHARSET = 314;
    public static final short CE8BS2000_CHARSET = 233;
    public static final short CL8EBCDIC1025R_CHARSET = 323;
    public static final short CL8EBCDIC1158R_CHARSET = 326;
    public static final short D8EBCDIC1141_CHARSET = 189;
    public static final short DK8EBCDIC1142_CHARSET = 198;
    public static final short EE8BS2000_CHARSET = 232;
    public static final short EE8EBCDIC870S_CHARSET = 316;
    public static final short EL8EBCDIC423R_CHARSET = 327;
    public static final short EL8EBCDIC875S_CHARSET = 311;
    public static final short EL8EBCDIC875R_CHARSET = 324;
    public static final short F8EBCDIC1147_CHARSET = 208;
    public static final short I8EBCDIC1144_CHARSET = 200;
    public static final short WE8BS2000E_CHARSET = 230;
    public static final short WE8EBCDIC1047E_CHARSET = 100;
    public static final short WE8EBCDIC1140_CHARSET = 7;
    public static final short WE8EBCDIC1145_CHARSET = 98;
    public static final short WE8EBCDIC1146_CHARSET = 9;
    public static final short WE8EBCDIC1148_CHARSET = 27;
    public static final short AR8EBCDIC420S_CHARSET = 320;
    public static final short IW8EBCDIC424S_CHARSET = 315;
    public static final short TR8EBCDIC1026S_CHARSET = 312;
    public static final short ZHT16HKSCS_CHARSET = 868;
    public static final short BLT8ISO8859P13_CHARSET = 47;
    public static final short AR8MSWIN1256_CHARSET = 560;
    public static final short S8EBCDIC1143_CHARSET = 199;
    public static final short ZHT16HKSCS31_CHARSET = 992;
    public static final short AZ8ISO8859P9E_CHARSET = 52;
    public static final short CEL8ISO8859P14_CHARSET = 48;
    public static final short CL8ISOIR111_CHARSET = 49;
    public static final short CL8KOI8U_CHARSET = 51;
    public static final short WE8PC858_CHARSET = 28;
    public static final short CL8EBCDIC1025C_CHARSET = 322;
    public static final short CL8EBCDIC1025S_CHARSET = 317;
    public static final short CL8EBCDIC1158_CHARSET = 325;
    public static final short EE8EBCDIC870C_CHARSET = 301;
    public static final short WE8EBCDIC924_CHARSET = 101;
    public static final short WE8EBCDIC1140C_CHARSET = 97;
    public static final short WE8EBCDIC1148C_CHARSET = 99;
    public static final short UNICODE_2_CHARSET = 871;
    private static CharacterSet asciiCharSet = null;
    static CharacterSetFactory factory;
    private int oracleId;
    int rep;
    static final ConcurrentHashMap<Integer, CharacterSet> CHARACTERSET_MAP;

    CharacterSet(int oracleId) {
        this.oracleId = oracleId;
    }

    public static CharacterSet make(int oracleId) {
        if (factory instanceof CharacterSetFactoryThin) {
            return CHARACTERSET_MAP.computeIfAbsent(oracleId, factory::make);
        }
        return factory.make(oracleId);
    }

    public String toString() {
        return (String)CharacterSetNamesMapHolder.ID_TO_NAME_MAP.get((short)this.oracleId);
    }

    public abstract boolean isLossyFrom(CharacterSet var1);

    public abstract boolean isConvertibleFrom(CharacterSet var1);

    public boolean isUnicode() {
        return false;
    }

    boolean isWellFormed(byte[] bytes, int offset, int count) {
        return true;
    }

    public int getOracleId() {
        return this.oracleId;
    }

    int getRep() {
        return this.rep;
    }

    public int getRatioTo(CharacterSet to) {
        throw new Error("oracle.sql.CharacterSet.getRationTo Not Implemented");
    }

    public boolean equals(Object rhs) {
        return rhs == this || rhs instanceof CharacterSet && this.oracleId == ((CharacterSet)rhs).oracleId;
    }

    public int hashCode() {
        return this.oracleId;
    }

    public abstract String toStringWithReplacement(byte[] var1, int var2, int var3);

    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        String str = this.toStringWithReplacement(bytes, offset, count);
        byte[] copy = this.convert(str);
        if (count != copy.length) {
            CharacterSet.failCharacterConversion(this);
        }
        for (int x = 0; x < count; ++x) {
            if (copy[x] == bytes[offset + x]) continue;
            CharacterSet.failCharacterConversion(this);
        }
        return null;
    }

    public abstract byte[] convert(String var1) throws SQLException;

    public abstract byte[] convertWithReplacement(String var1);

    public byte[] convertWithReplacement(char[] chars, int charOffset, byte[] bytes, int byteOffset, int[] nchars) {
        byte[] tempBytes = this.convertWithReplacement(new String(chars, charOffset, nchars[0]));
        if (tempBytes != null) {
            nchars[0] = tempBytes.length;
            if (bytes != null) {
                System.arraycopy(tempBytes, 0, bytes, byteOffset, tempBytes.length);
                return bytes;
            }
        }
        return tempBytes;
    }

    public abstract byte[] convert(CharacterSet var1, byte[] var2, int var3, int var4) throws SQLException;

    public byte[] convertUnshared(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        byte[] result = this.convert(from, source, offset, count);
        if (result == source) {
            result = new byte[source.length];
            System.arraycopy(source, 0, result, 0, count);
        }
        return result;
    }

    abstract int decode(CharacterWalker var1) throws SQLException;

    abstract void encode(CharacterBuffer var1, int var2) throws SQLException;

    static final void failCharacterConversion(CharacterSet which) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(55, which).fillInStackTrace();
    }

    static final byte[] useOrCopy(byte[] bytes, int offset, int count) {
        byte[] result;
        if (bytes.length == count && offset == 0) {
            result = bytes;
        } else {
            result = new byte[count];
            System.arraycopy(bytes, offset, result, 0, count);
        }
        return result;
    }

    static final void need(CharacterBuffer buffer, int n) {
        int needed = n + buffer.next;
        int wanted = buffer.bytes.length;
        if (needed <= wanted) {
            return;
        }
        while (needed > wanted) {
            wanted = 2 * wanted;
        }
        byte[] old = buffer.bytes;
        buffer.bytes = new byte[wanted];
        System.arraycopy(old, 0, buffer.bytes, 0, buffer.next);
    }

    public static final String UTFToString(byte[] bytes, int offset, int nbytes, boolean useReplacementChar) throws SQLException {
        return new String(CharacterSet.UTFToJavaChar(bytes, offset, nbytes, useReplacementChar));
    }

    public static final String UTFToString(byte[] bytes, int offset, int nbytes) throws SQLException {
        return CharacterSet.UTFToString(bytes, offset, nbytes, false);
    }

    public static final char[] UTFToJavaChar(byte[] bytes, int offset, int count) throws SQLException {
        return CharacterSet.UTFToJavaChar(bytes, offset, count, false);
    }

    public static final char[] UTFToJavaChar(byte[] bytes, int offset, int count, boolean useReplacementChar) throws SQLException {
        char[] chars = null;
        chars = new char[count];
        int[] countArr = new int[]{count};
        int chars_index = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, 0, countArr, useReplacementChar);
        char[] rchars = new char[chars_index];
        System.arraycopy(chars, 0, rchars, 0, chars_index);
        chars = null;
        return rchars;
    }

    public static final char[] UTFToJavaCharWithReplacement(byte[] bytes, int offset, int count) {
        char[] chars = null;
        try {
            chars = new char[count];
            int[] countArr = new int[]{count};
            int chars_index = CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, 0, countArr, true);
            char[] rchars = new char[chars_index];
            System.arraycopy(chars, 0, rchars, 0, chars_index);
            chars = null;
            return rchars;
        }
        catch (SQLException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static final int convertUTFBytesToJavaChars(byte[] bytes, int offset, char[] chars, int chars_offset, int[] countArr, boolean convertWithReplacement) throws SQLException {
        return CharacterSet.convertUTFBytesToJavaChars(bytes, offset, chars, chars_offset, countArr, convertWithReplacement, chars.length - chars_offset);
    }

    public static final int convertUTFBytesToJavaChars(byte[] bytes, int offset, char[] chars, int chars_offset, int[] countArr, boolean convertWithReplacement, int charSize) throws SQLException {
        int b;
        CharacterConverterBehavior ccb = convertWithReplacement ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
        int count = countArr[0];
        countArr[0] = 0;
        int bytes_index = offset;
        int bytes_end = offset + count;
        int chars_index = chars_offset;
        int charsLength = chars_offset + charSize;
        while (bytes_index < bytes_end) {
            char c2;
            byte bb;
            byte c = bytes[bytes_index++];
            b = c & 0xF0;
            if (c >= 0) {
                if (chars_index < charsLength) {
                    chars[chars_index++] = (char)(c & 0xFFFFFFFF);
                    if (bytes_end > bytes.length || charsLength > chars.length || bytes_index >= bytes_end || chars_index >= charsLength || bytes_index < 0 || chars_index < 0) continue;
                    while (bytes_index < bytes_end && chars_index < charsLength && (bb = bytes[bytes_index]) >= 0) {
                        chars[chars_index] = (char)(bb & 0xFFFFFFFF);
                        ++chars_index;
                        ++bytes_index;
                    }
                    continue;
                }
                countArr[0] = bytes_end - bytes_index + 2;
                break;
            }
            bb = c;
            if ((bb = (byte)(bb << 2)) >= 0) {
                if (bytes_index >= bytes_end) {
                    countArr[0] = 1;
                    ccb.onFailConversion();
                    break;
                }
                c2 = CharacterSet.conv2ByteUTFtoUTF16(c, bytes[bytes_index++]);
                if (chars_index >= charsLength) {
                    countArr[0] = bytes_end - bytes_index + 3;
                    break;
                }
                chars[chars_index++] = c2;
                ccb.onFailConversion(c2);
                continue;
            }
            if ((bb = (byte)(bb << 1)) >= 0) {
                if (bytes_index + 1 >= bytes_end) {
                    countArr[0] = bytes_end - bytes_index + 1;
                    ccb.onFailConversion();
                    break;
                }
                char c1 = CharacterSet.conv3ByteUTFtoUTF16(c, bytes[bytes_index++], bytes[bytes_index++]);
                if (b != 244 && bytes[bytes_index - 2] != -65 && bytes[bytes_index - 1] != -67) {
                    ccb.onFailConversion(c1);
                }
                if (CharacterSet.isHiSurrogate(c1)) {
                    if (chars_index > charsLength - 2) {
                        countArr[0] = bytes_end - bytes_index + 4;
                        break;
                    }
                    if (bytes_index >= bytes_end) continue;
                    c = bytes[bytes_index];
                    if ((byte)(c & 0xF0) != -32) {
                        chars[chars_index++] = 65533;
                        ccb.onFailConversion();
                        continue;
                    }
                    if (++bytes_index + 1 >= bytes_end) {
                        countArr[0] = bytes_end - bytes_index + 1;
                        ccb.onFailConversion();
                        break;
                    }
                    if (CharacterSet.isLoSurrogate(c2 = CharacterSet.conv3ByteUTFtoUTF16(c, bytes[bytes_index++], bytes[bytes_index++]))) {
                        chars[chars_index++] = c1;
                    } else {
                        chars[chars_index++] = 65533;
                        ccb.onFailConversion();
                    }
                    chars[chars_index++] = c2;
                    continue;
                }
                if (chars_index < charsLength) {
                    chars[chars_index++] = c1;
                    continue;
                }
                countArr[0] = bytes_end - bytes_index + 4;
                break;
            }
            if (chars_index >= charsLength) {
                countArr[0] = bytes_end - bytes_index + 2;
                break;
            }
            chars[chars_index++] = 65533;
            ccb.onFailConversion();
        }
        b = chars_index - chars_offset;
        return b;
    }

    public static final byte[] stringToUTF(String str) {
        char[] chararr = str.toCharArray();
        int maxNbBytes = chararr.length * 3;
        byte[] bytearr = null;
        byte[] rbytearr = null;
        bytearr = new byte[maxNbBytes];
        int byte_len = CharacterSet.convertJavaCharsToUTFBytes(chararr, 0, bytearr, 0, chararr.length);
        rbytearr = new byte[byte_len];
        System.arraycopy(bytearr, 0, rbytearr, 0, byte_len);
        bytearr = null;
        return rbytearr;
    }

    public static final int convertJavaCharsToUTFBytes(char[] chars, int chars_offset, byte[] bytes, int bytes_begin, int chars_count) {
        int c;
        int chars_begin = chars_offset;
        int chars_end = chars_offset + chars_count;
        int byte_index = bytes_begin;
        for (int i = chars_begin; i < chars_end; ++i) {
            c = chars[i];
            if (c >= 0 && c <= 127) {
                bytes[byte_index++] = (byte)c;
                continue;
            }
            if (c > 2047) {
                bytes[byte_index++] = (byte)(0xE0 | c >>> 12 & 0xF);
                bytes[byte_index++] = (byte)(0x80 | c >>> 6 & 0x3F);
                bytes[byte_index++] = (byte)(0x80 | c >>> 0 & 0x3F);
                continue;
            }
            bytes[byte_index++] = (byte)(0xC0 | c >>> 6 & 0x1F);
            bytes[byte_index++] = (byte)(0x80 | c >>> 0 & 0x3F);
        }
        c = byte_index - bytes_begin;
        return c;
    }

    private static final int UTFStringLength(byte[] bytes, int offset, int count) {
        int strlen = 0;
        int bytes_index = offset;
        int bytes_end = offset + count;
        while (bytes_index < bytes_end) {
            byte b = bytes[bytes_index];
            if (b >= 0) {
                ++bytes_index;
                ++strlen;
                continue;
            }
            if ((b = (byte)(b << 2)) >= 0) {
                if (bytes_index + 1 >= bytes_end) {
                    bytes_index = bytes_end;
                    continue;
                }
                ++strlen;
                bytes_index += 2;
                continue;
            }
            if ((b = (byte)(b << 1)) >= 0) {
                if (bytes_index + 2 >= bytes_end) {
                    bytes_index = bytes_end;
                    continue;
                }
                ++strlen;
                bytes_index += 3;
                continue;
            }
            if ((b = (byte)(b << 1)) >= 0) {
                if (bytes_index + 3 >= bytes_end) {
                    bytes_index = bytes_end;
                    continue;
                }
                strlen += 2;
                bytes_index += 4;
                continue;
            }
            ++bytes_index;
            ++strlen;
        }
        return strlen;
    }

    public static final int stringUTFLength(String s) {
        char[] carr = s.toCharArray();
        return CharacterSet.charArrayUTF8Length(carr);
    }

    static final int charArrayUTF8Length(char[] carr) {
        int utflen = 0;
        for (char c : carr) {
            if (c >= '\u0000' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static final String AL32UTF8ToString(byte[] bytes, int offset, int nbytes) {
        return CharacterSet.AL32UTF8ToString(bytes, offset, nbytes, false);
    }

    public static final String AL32UTF8ToString(byte[] bytes, int offset, int nbytes, boolean useReplacementCharacter) {
        char[] chars = null;
        try {
            chars = CharacterSet.AL32UTF8ToJavaChar(bytes, offset, nbytes, useReplacementCharacter);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return new String(chars);
    }

    public static final char[] AL32UTF8ToJavaChar(byte[] bytes, int offset, int count, boolean useReplacementCharacter) throws SQLException {
        char[] chars = null;
        try {
            chars = new char[count];
            int[] countArr = new int[]{count};
            int clen = CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, offset, chars, 0, countArr, useReplacementCharacter);
            char[] rchars = new char[clen];
            System.arraycopy(chars, 0, rchars, 0, clen);
            chars = null;
            return rchars;
        }
        catch (SQLException e) {
            CharacterSet.failUTFConversion();
            return new char[0];
        }
    }

    public static final int convertAL32UTF8BytesToJavaChars(byte[] bytes, int offsetBytes, char[] chars, int offsetChars, int[] countArr, boolean convertWithReplacement) throws SQLException {
        return CharacterSet.convertAL32UTF8BytesToJavaChars(bytes, offsetBytes, chars, offsetChars, countArr, convertWithReplacement, chars.length - offsetChars);
    }

    public static final int convertAL32UTF8BytesToJavaChars(byte[] bytes, int offsetBytes, char[] chars, int offsetChars, int[] countArr, boolean convertWithReplacement, int charSize) throws SQLException {
        int w;
        CharacterConverterBehavior ccb = convertWithReplacement ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
        int count = countArr[0];
        countArr[0] = 0;
        int bytes_index = offsetBytes;
        int bytes_end = offsetBytes + count;
        int chars_index = offsetChars;
        int charsLength = offsetChars + charSize;
        while (bytes_index < bytes_end) {
            char c2;
            byte bb;
            byte c = bytes[bytes_index++];
            int b = c & 0xF0;
            if (c >= 0) {
                if (chars_index < charsLength) {
                    chars[chars_index++] = (char)(c & 0xFFFFFFFF);
                    if (bytes_end > bytes.length || charsLength > chars.length || bytes_index >= bytes_end || chars_index >= charsLength || bytes_index < 0 || chars_index < 0) continue;
                    while (bytes_index < bytes_end && chars_index < charsLength && (bb = bytes[bytes_index]) >= 0) {
                        chars[chars_index] = (char)(bb & 0xFFFFFFFF);
                        ++chars_index;
                        ++bytes_index;
                    }
                    continue;
                }
                countArr[0] = bytes_end - bytes_index + 2;
                break;
            }
            bb = c;
            if ((bb = (byte)(bb << 2)) >= 0) {
                if (bytes_index >= bytes_end) {
                    countArr[0] = 1;
                    ccb.onFailConversion();
                    break;
                }
                c2 = CharacterSet.conv2ByteUTFtoUTF16(c, bytes[bytes_index++]);
                if (chars_index >= charsLength) {
                    countArr[0] = bytes_end - bytes_index + 3;
                    break;
                }
                chars[chars_index++] = c2;
                ccb.onFailConversion(c2);
                continue;
            }
            if ((bb = (byte)(bb << 1)) >= 0) {
                if (bytes_index + 1 >= bytes_end) {
                    countArr[0] = bytes_end - bytes_index + 1;
                    ccb.onFailConversion();
                    break;
                }
                c2 = CharacterSet.conv3ByteAL32UTF8toUTF16(c, bytes[bytes_index++], bytes[bytes_index++]);
                if (chars_index >= charsLength) {
                    countArr[0] = bytes_end - bytes_index + 4;
                    break;
                }
                chars[chars_index++] = c2;
                if (b == 244 || bytes[bytes_index - 2] == -65 || bytes[bytes_index - 1] == -67) continue;
                ccb.onFailConversion(c2);
                continue;
            }
            if ((bb = (byte)(bb << 1)) >= 0) {
                if (bytes_index + 2 >= bytes_end) {
                    countArr[0] = bytes_end - bytes_index + 1;
                    ccb.onFailConversion();
                    break;
                }
                if (chars_index > charsLength - 2) {
                    countArr[0] = bytes_end - bytes_index + 2;
                    break;
                }
                if ((w = CharacterSet.conv4ByteAL32UTF8toUTF16(c, bytes[bytes_index++], bytes[bytes_index++], bytes[bytes_index++], chars, chars_index)) == 1) {
                    ccb.onFailConversion();
                    ++chars_index;
                    continue;
                }
                chars_index += 2;
                continue;
            }
            if (chars_index >= charsLength) {
                countArr[0] = bytes_end - bytes_index + 2;
                break;
            }
            chars[chars_index++] = 65533;
            ccb.onFailConversion();
        }
        w = chars_index - offsetChars;
        return w;
    }

    public static final byte[] stringToAL32UTF8(String str) {
        char[] chararr = str.toCharArray();
        int maxNbBytes = chararr.length * 3;
        byte[] bytearr = null;
        byte[] rbytearr = null;
        bytearr = new byte[maxNbBytes];
        int byte_len = CharacterSet.convertJavaCharsToAL32UTF8Bytes(chararr, 0, bytearr, 0, chararr.length);
        rbytearr = new byte[byte_len];
        System.arraycopy(bytearr, 0, rbytearr, 0, byte_len);
        bytearr = null;
        return rbytearr;
    }

    public static final int convertJavaCharsToAL32UTF8Bytes(char[] chars, int chars_offset, byte[] bytes, int bytes_begin, int chars_count) {
        int uuuuu;
        int chars_begin = chars_offset;
        int chars_end = chars_offset + chars_count;
        int byte_index = bytes_begin;
        for (int i = chars_begin; i < chars_end; ++i) {
            char c = chars[i];
            char c2 = '\u0000';
            if (c >= '\u0000' && c <= '\u007f') {
                bytes[byte_index++] = (byte)c;
                continue;
            }
            if (CharacterSet.isHiSurrogate(c)) {
                if (i + 1 < chars_end && CharacterSet.isLoSurrogate(c2 = chars[i + 1])) {
                    uuuuu = (c >>> 6 & 0xF) + 1;
                    bytes[byte_index++] = (byte)(uuuuu >>> 2 | 0xF0);
                    bytes[byte_index++] = (byte)((uuuuu & 3) << 4 | c >>> 2 & 0xF | 0x80);
                    bytes[byte_index++] = (byte)((c & 3) << 4 | c2 >>> 6 & 0xF | 0x80);
                    bytes[byte_index++] = (byte)(c2 & 0x3F | 0x80);
                    ++i;
                    continue;
                }
                bytes[byte_index++] = -17;
                bytes[byte_index++] = -65;
                bytes[byte_index++] = -67;
                continue;
            }
            if (c > '\u07ff') {
                bytes[byte_index++] = (byte)(0xE0 | c >>> 12 & 0xF);
                bytes[byte_index++] = (byte)(0x80 | c >>> 6 & 0x3F);
                bytes[byte_index++] = (byte)(0x80 | c >>> 0 & 0x3F);
                continue;
            }
            bytes[byte_index++] = (byte)(0xC0 | c >>> 6 & 0x1F);
            bytes[byte_index++] = (byte)(0x80 | c >>> 0 & 0x3F);
        }
        uuuuu = byte_index - bytes_begin;
        return uuuuu;
    }

    public static final int string32UTF8Length(String s) {
        return CharacterSet.charArray32UTF8Length(s.toCharArray());
    }

    static final int charArray32UTF8Length(char[] carr) {
        int utflen = 0;
        int slen = carr.length;
        for (int i = 0; i < slen; ++i) {
            char c = carr[i];
            if (c >= '\u0000' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                if (CharacterSet.isHiSurrogate(c)) {
                    if (i + 1 >= slen) continue;
                    utflen += 4;
                    ++i;
                    continue;
                }
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        return utflen;
    }

    public static final String AL16UTF16BytesToString(byte[] bytes, int nbytes) {
        char[] chars = new char[nbytes >>> 1];
        CharacterSet.AL16UTF16BytesToJavaChars(bytes, nbytes, chars);
        return new String(chars);
    }

    public static final int AL16UTF16BytesToJavaChars(byte[] bytes, int nbytes, char[] chars) {
        int chars_i;
        int charMax = nbytes >>> 1;
        int bytes_i = 0;
        for (chars_i = 0; chars_i < charMax; ++chars_i) {
            int hibyte = bytes[bytes_i] << 8;
            chars[chars_i] = (char)(hibyte | bytes[bytes_i + 1] & 0xFF);
            bytes_i += 2;
        }
        return chars_i;
    }

    public static final int convertAL16UTF16BytesToJavaChars(byte[] bytes, int offset, char[] chars, int chars_offset, int count, boolean convertWithReplacement) throws SQLException {
        CharacterConverterBehavior ccb = convertWithReplacement ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
        int chars_i = chars_offset;
        int bytes_i = offset;
        int bytes_end = offset + count;
        while (bytes_i + 1 < bytes_end) {
            int hibyte = bytes[bytes_i] << 8;
            char c = (char)(hibyte | bytes[bytes_i + 1] & 0xFF);
            chars[chars_i++] = c;
            bytes_i += 2;
        }
        bytes_i = chars_i - chars_offset;
        return bytes_i;
    }

    public static final int convertAL16UTF16LEBytesToJavaChars(byte[] bytes, int offset, char[] chars, int chars_offset, int count, boolean convertWithReplacement) throws SQLException {
        CharacterConverterBehavior ccb = convertWithReplacement ? CharacterConverterBehavior.REPLACEMENT : CharacterConverterBehavior.REPORT_ERROR;
        int chars_i = chars_offset;
        int bytes_i = offset;
        int bytes_end = offset + count;
        while (bytes_i + 1 < bytes_end) {
            int hibyte = bytes[bytes_i + 1] << 8;
            int c = hibyte | bytes[bytes_i] & 0xFF;
            if (CharacterSet.isHiSurrogate((char)c)) {
                if ((bytes_i += 2) + 1 < bytes_end) {
                    char c2 = (char)((bytes[bytes_i + 1] << 8) + (bytes[bytes_i] & 0xFF));
                    chars[chars_i++] = CharacterSet.isLoSurrogate(c2) ? c : 65533;
                    chars[chars_i++] = c2;
                }
            } else {
                chars[chars_i++] = c;
            }
            bytes_i += 2;
        }
        bytes_i = chars_i - chars_offset;
        return bytes_i;
    }

    public static final byte[] stringToAL16UTF16Bytes(String str) {
        char[] chars = str.toCharArray();
        int nchars = chars.length;
        byte[] bytes = new byte[nchars * 2];
        CharacterSet.javaCharsToAL16UTF16Bytes(chars, nchars, bytes);
        return bytes;
    }

    public static final int javaCharsToAL16UTF16Bytes(char[] chars, int nchars, byte[] bytes) {
        int charsMax = Math.min(nchars, bytes.length >>> 1);
        return CharacterSet.convertJavaCharsToAL16UTF16Bytes(chars, 0, bytes, 0, charsMax);
    }

    public static final int convertJavaCharsToAL16UTF16Bytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars) {
        int chars_i = chars_offset;
        int bytes_i = bytes_offset;
        int char_end = chars_offset + nchars;
        while (chars_i < char_end) {
            bytes[bytes_i] = (byte)(chars[chars_i] >>> 8 & 0xFF);
            bytes[bytes_i + 1] = (byte)(chars[chars_i] & 0xFF);
            ++chars_i;
            bytes_i += 2;
        }
        return bytes_i - bytes_offset;
    }

    public static final byte[] stringToAL16UTF16LEBytes(String str) {
        char[] chars = str.toCharArray();
        byte[] bytes = new byte[chars.length * 2];
        CharacterSet.javaCharsToAL16UTF16LEBytes(chars, chars.length, bytes);
        return bytes;
    }

    public static final int javaCharsToAL16UTF16LEBytes(char[] chars, int nchars, byte[] bytes) {
        return CharacterSet.convertJavaCharsToAL16UTF16LEBytes(chars, 0, bytes, 0, nchars);
    }

    public static final int convertJavaCharsToAL16UTF16LEBytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars) {
        int chars_i = chars_offset;
        int bytes_i = bytes_offset;
        int char_end = chars_offset + nchars;
        while (chars_i < char_end) {
            bytes[bytes_i] = (byte)(chars[chars_i] & 0xFF);
            bytes[bytes_i + 1] = (byte)(chars[chars_i] >>> 8);
            ++chars_i;
            bytes_i += 2;
        }
        return bytes_i - bytes_offset;
    }

    public static final int convertASCIIBytesToJavaChars(byte[] bytes, int bytes_offset, char[] chars, int chars_offset, int count) throws SQLException {
        int lastChar = chars_offset + count;
        int i = chars_offset;
        int j = bytes_offset;
        while (i < lastChar) {
            chars[i] = (char)(0xFF & bytes[j]);
            ++i;
            ++j;
        }
        return count;
    }

    public static final int convertJavaCharsToASCIIBytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars) throws SQLException {
        CharacterSet.convertJavaCharsToASCIIBytes(chars, chars_offset, bytes, bytes_offset, nchars, false);
        return nchars;
    }

    public static final int convertJavaCharsToASCIIBytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars, boolean strictConversion) throws SQLException {
        if (strictConversion) {
            if (asciiCharSet == null) {
                asciiCharSet = CharacterSet.make(1);
            }
            byte[] tempBytes = asciiCharSet.convertWithReplacement(new String(chars, chars_offset, nchars));
            System.arraycopy(tempBytes, 0, bytes, bytes_offset, tempBytes.length);
            return tempBytes.length;
        }
        for (int i = 0; i < nchars; ++i) {
            bytes[bytes_offset + i] = (byte)chars[chars_offset + i];
        }
        return nchars;
    }

    public static final int convertJavaCharsToISOLATIN1Bytes(char[] chars, int chars_offset, byte[] bytes, int bytes_offset, int nchars) throws SQLException {
        for (int i = 0; i < nchars; ++i) {
            char c = chars[chars_offset + i];
            bytes[bytes_offset + i] = c > '\u00ff' ? -65 : (byte)c;
        }
        return nchars;
    }

    public static final byte[] stringToASCII(String str) {
        return str.getBytes(StandardCharsets.US_ASCII);
    }

    public static final long convertUTF32toUTF16(long ucs4ch) {
        if (ucs4ch > 65535L) {
            long utf16str = 0xD8L | ucs4ch - 65536L >> 18 & 0xFFL;
            utf16str = ucs4ch - 65536L >> 10 & 0xFFL | utf16str << 8;
            utf16str = 0xDCL | (ucs4ch & 0x3FFL) >> 8 & 0xFFL | utf16str << 8;
            utf16str = ucs4ch & 0xFFL | utf16str << 8;
            return utf16str;
        }
        return ucs4ch;
    }

    static final boolean isHiSurrogate(char c) {
        return (char)(c & 0xFC00) == '\ud800';
    }

    static final boolean isLoSurrogate(char c) {
        return (char)(c & 0xFC00) == '\udc00';
    }

    static final boolean check80toBF(byte b) {
        return (b & 0xFFFFFFC0) == -128;
    }

    static final boolean check80to8F(byte b) {
        return (b & 0xFFFFFFF0) == -128;
    }

    static final boolean check80to9F(byte b) {
        return (b & 0xFFFFFFE0) == -128;
    }

    static final boolean checkA0toBF(byte b) {
        return (b & 0xFFFFFFE0) == -96;
    }

    static final boolean check90toBF(byte b) {
        return (b & 0xFFFFFFC0) == -128 && (b & 0x30) != 0;
    }

    static final char conv2ByteUTFtoUTF16(byte c, byte c2) {
        if (c < -62 || c > -33 || !CharacterSet.check80toBF(c2)) {
            return '\ufffd';
        }
        return (char)((c & 0x1F) << 6 | c2 & 0x3F);
    }

    static final char conv3ByteUTFtoUTF16(byte c, byte c2, byte c3) {
        if (!(c == -32 && CharacterSet.checkA0toBF(c2) && CharacterSet.check80toBF(c3) || c >= -31 && c <= -17 && CharacterSet.check80toBF(c2) && CharacterSet.check80toBF(c3))) {
            return '\ufffd';
        }
        return (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
    }

    static final char conv3ByteAL32UTF8toUTF16(byte c, byte c2, byte c3) {
        if (!(c == -32 && CharacterSet.checkA0toBF(c2) && CharacterSet.check80toBF(c3) || c >= -31 && c <= -20 && CharacterSet.check80toBF(c2) && CharacterSet.check80toBF(c3) || c == -19 && CharacterSet.check80to9F(c2) && CharacterSet.check80toBF(c3) || c >= -18 && c <= -17 && CharacterSet.check80toBF(c2) && CharacterSet.check80toBF(c3))) {
            return '\ufffd';
        }
        return (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
    }

    static final int conv4ByteAL32UTF8toUTF16(byte c, byte c2, byte c3, byte c4, char[] chars, int cpos) {
        boolean chars_count = false;
        if (!(c == -16 && CharacterSet.check90toBF(c2) && CharacterSet.check80toBF(c3) && CharacterSet.check80toBF(c4) || c >= -15 && c <= -13 && CharacterSet.check80toBF(c2) && CharacterSet.check80toBF(c3) && CharacterSet.check80toBF(c4) || c == -12 && CharacterSet.check80to8F(c2) && CharacterSet.check80toBF(c3) && CharacterSet.check80toBF(c4))) {
            chars[cpos] = 65533;
            return 1;
        }
        chars[cpos] = (char)((((c & 7) << 2 | c2 >>> 4 & 3) - 1 & 0xF) << 6 | (c2 & 0xF) << 2 | c3 >>> 4 & 3 | 0xD800);
        chars[cpos + 1] = (char)((c3 & 0xF) << 6 | c4 & 0x3F | 0xDC00);
        return 2;
    }

    static void failUTFConversion() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(55).fillInStackTrace();
    }

    public int encodedByteLength(String s) throws SQLException {
        if (s == null || s.length() == 0) {
            return 0;
        }
        return this.convertWithReplacement(s).length;
    }

    public int encodedByteLength(char[] carray) {
        if (carray == null || carray.length == 0) {
            return 0;
        }
        return this.convertWithReplacement(new String(carray)).length;
    }

    public int toCharWithReplacement(byte[] srcChar, int offset, char[] dstChar, int dstOffset, int count) throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    public boolean isUnknown() {
        return false;
    }

    static {
        try {
            Class.forName("oracle.i18n.text.converter.CharacterConverterSJIS");
            CharacterSetWithConverter.ccFactory = new CharacterConverterFactoryOGS();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        factory = new CharacterSetFactoryDefault();
        CHARACTERSET_MAP = new ConcurrentHashMap();
    }

    private static class CharacterSetNamesMapHolder {
        private static final Map<Short, String> ID_TO_NAME_MAP = CharacterSetNamesMapHolder.generateIdToNameMap();

        private CharacterSetNamesMapHolder() {
        }

        private static final Map<Short, String> generateIdToNameMap() {
            Class<CharacterSet> characterSetClass = CharacterSet.class;
            Field[] fields = characterSetClass.getFields();
            HashMap<Short, String> tempCharacterSetNames = new HashMap<Short, String>();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    String name = fields[i].getName();
                    int suffixIndex = name.lastIndexOf("_CHARSET");
                    if (suffixIndex == -1 || (name = name.substring(0, suffixIndex)).equals("ASCII") || name.equals("ISO_LATIN_1") || name.equals("AR8MSAWIN") || name.equals("UNICODE_1") || name.equals("UNICODE_2")) continue;
                    short id = fields[i].getShort(CharacterSet.class);
                    int mod = fields[i].getModifiers();
                    if (!Modifier.isStatic(mod) || !Modifier.isFinal(mod)) continue;
                    String temp = (String)tempCharacterSetNames.get(new Short(id));
                    if (temp != null) {
                        throw new RuntimeException("duplicate field name: " + name + " for id: " + id);
                    }
                    tempCharacterSetNames.put(new Short(id), name);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed for field: " + fields[i], e);
                }
            }
            return tempCharacterSetNames;
        }
    }

    static abstract class CharacterConverterBehavior {
        public static final char[] NULL_CHARS = new char[1];
        public static final char UTF16_REPLACEMENT_CHAR = '\ufffd';
        public static final CharacterConverterBehavior REPORT_ERROR = new CharacterConverterBehavior("Report Error"){

            @Override
            public void onFailConversion() throws SQLException {
                throw (SQLException)DatabaseError.createSqlException(55).fillInStackTrace();
            }

            @Override
            public void onFailConversion(char c) throws SQLException {
                if (c == '\ufffd') {
                    throw (SQLException)DatabaseError.createSqlException(55).fillInStackTrace();
                }
            }
        };
        public static final CharacterConverterBehavior REPLACEMENT = new CharacterConverterBehavior("Replacement"){

            @Override
            public void onFailConversion() throws SQLException {
            }

            @Override
            public void onFailConversion(char c) throws SQLException {
            }
        };
        private final String m_name;

        public CharacterConverterBehavior(String name) {
            this.m_name = name;
        }

        public abstract void onFailConversion(char var1) throws SQLException;

        public abstract void onFailConversion() throws SQLException;
    }
}

