/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.logging.Level;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlob;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.driver.TxnReplayableConnection;

@ProxyFor(value={oracle.jdbc.internal.OracleBlob.class})
@ProxyAccess(value=ACProxyable.class)
public abstract class TxnReplayableBlob
extends TxnReplayableBase
implements JDBCReplayable {
    private static final Method GETBINSTREAM_METHOD = TxnReplayableBlob.getGetBinaryStreamMethod();
    private static final Method GETBINSTREAM_LONG_METHOD = TxnReplayableBlob.getGetBinaryStreamLongMethod();
    private static final Method GETBINSTREAM_LONG_LONG_METHOD = TxnReplayableBlob.getGetBinaryStreamLongLongMethod();
    private static final Method SETBINSTREAM_LONG_METHOD = TxnReplayableBlob.getSetBinaryStreamLongMethod();
    private static final String CLASS_NAME = "oracle.jdbc.replay.driver.TxnReplayableBlob";

    protected TxnReplayableBlob() {
    }

    private static final Method getGetBinaryStreamMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", new Class[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getGetBinaryStreamLongLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("getBinaryStream", Long.TYPE, Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final Method getSetBinaryStreamLongMethod() {
        try {
            return oracle.jdbc.internal.OracleBlob.class.getMethod("setBinaryStream", Long.TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method m, Object receiver, Object ... args) {
        super.preForAll(m, receiver, args);
    }

    @Override
    @Post
    protected void postForAll(Method m) {
        this.postForAll(m, null);
    }

    @Override
    @Post
    protected Object postForAll(Method m, Object result) {
        if (result instanceof TxnReplayableBase) {
            TxnReplayableBase jdbcProxy = (TxnReplayableBase)result;
            jdbcProxy.setFailoverManager(this.getFailoverManager());
        }
        return super.postForAll(m, result);
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={})})
    protected void postForClose(Method m) {
        this.postForAll(m);
        TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
        TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
        OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
        if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
            this.isLogicallyClosed = true;
            try {
                connProxy.checkImplicitRequestBoundary();
            }
            catch (Throwable error) {
                this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForClose", "On Blob {0}, implicit boundary check failed", (String)null, (Throwable)null, (Object)this);
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="free", args={})})
    protected void postForFree(Method m) {
        super.postForAll(m);
        if (!this.isFreed) {
            TxnFailoverManagerImpl.ReplayLifecycle lifecycle = this.failoverMngr.getReplayLifecycle();
            TxnReplayableConnection connProxy = (TxnReplayableConnection)this.failoverMngr.getConnectionProxy();
            OracleConnection oconn = (OracleConnection)connProxy.getDelegate();
            if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && oconn.isUsable(false)) {
                if (lifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                    this.failoverMngr.setStateSignatureSyncUp();
                }
                try {
                    connProxy.checkImplicitRequestBoundary();
                }
                catch (Throwable error) {
                    this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "postForFree", "On Blob {0}, implicit boundary check failed", (String)null, (Throwable)null, (Object)this);
                }
            }
        }
        this.isFreed = true;
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method m, SQLException error) throws SQLException {
        super.onErrorVoidForAll(m, error);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method m, SQLException error) throws SQLException {
        return super.onErrorForAll(m, error);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    public InputStream getBinaryStream() throws SQLException {
        if (GETBINSTREAM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, new Object[0]);
        try {
            oracle.jdbc.internal.OracleBlob delegate = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            InputStream delegateReturn = delegate.canReadBasicLobDataInLocator() ? delegate.getBinaryStream() : delegate.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), delegate.getBufferSize(), 0L);
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public InputStream getBinaryStream(long pos) throws SQLException {
        if (GETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos);
        try {
            InputStream delegateReturn;
            oracle.jdbc.internal.OracleBlob delegate = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            if (delegate.canReadBasicLobDataInLocator()) {
                delegateReturn = delegate.getBinaryStream(pos);
            } else {
                if (pos < 1L) {
                    SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 68);
                    sqlexc.fillInStackTrace();
                    throw sqlexc;
                }
                delegateReturn = delegate.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), delegate.getBufferSize(), pos);
            }
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        if (GETBINSTREAM_LONG_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get binary stream");
        }
        Method m = GETBINSTREAM_LONG_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos, length);
        try {
            InputStream delegateReturn;
            oracle.jdbc.internal.OracleBlob delegate = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            if (delegate.canReadBasicLobDataInLocator()) {
                delegateReturn = delegate.getBinaryStream(pos, length);
            } else {
                long lobLen = delegate.length();
                if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
                    SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 68);
                    sqlexc.fillInStackTrace();
                    throw sqlexc;
                }
                delegateReturn = delegate.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)((Object)this), delegate.getBufferSize(), pos, length);
            }
            return (InputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (InputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        if (SETBINSTREAM_LONG_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot set binary stream");
        }
        Method m = SETBINSTREAM_LONG_METHOD;
        this.failoverMngr.setLobStreamInRequest(true);
        this.preForAll(m, this, pos);
        try {
            oracle.jdbc.internal.OracleBlob delegate = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
            if (this.isFreed) {
                SQLException sqlexc = DatabaseError.createSqlException(delegate.getInternalConnection(), 192);
                sqlexc.fillInStackTrace();
                throw sqlexc;
            }
            OutputStream delegateReturn = delegate.getDBAccess().newOutputStream((oracle.jdbc.internal.OracleBlob)((Object)this), delegate.getBufferSize(), pos, true);
            return (OutputStream)this.postForAll(m, delegateReturn);
        }
        catch (SQLException sqlexc) {
            return (OutputStream)this.postForAll(m, this.onErrorForAll(m, sqlexc));
        }
    }

    public OutputStream getBinaryOutputStream() throws SQLException {
        return this.setBinaryStream(1L);
    }

    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        return this.setBinaryStream(pos);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection getInternalConnection() throws SQLException {
        oracle.jdbc.internal.OracleBlob delegate = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
        return delegate.getInternalConnection();
    }

    @Override
    protected OracleConnection getConnectionInDelegate() throws SQLException {
        return this.getInternalConnection();
    }

    @Override
    protected void replugWithoutCreator(OracleConnection newConn) throws SQLException {
        oracle.jdbc.internal.OracleBlob oldDelegate = (oracle.jdbc.internal.OracleBlob)this.getDelegate();
        OracleBlob newlob = new OracleBlob(newConn, oldDelegate.getBytes());
        this.setDelegate(newlob);
        this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "replugWithoutCreator", "On Blob {0}, replugged delegate: {1}", (String)null, (Throwable)null, new Object[]{this.hashCode(), newlob});
    }
}

