/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleOCIConnectionPool;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
public abstract class OracleOCIConnection
extends T2CConnection {
    OracleOCIConnectionPool ociConnectionPool = null;
    boolean isPool = false;
    boolean aliasing = false;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;

    public OracleOCIConnection(String string, Properties properties, Object object) throws SQLException {
        this(string, properties, (OracleDriverExtension)object);
    }

    OracleOCIConnection(String string, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, properties, oracleDriverExtension);
    }

    public synchronized byte[] getConnectionId() throws SQLException {
        byte[] byArray = this.t2cGetConnectionId(this.m_nativeState);
        if (byArray == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254, "Cannot create a ByteArray for the connectionId").fillInStackTrace();
        }
        this.aliasing = true;
        return byArray;
    }

    public synchronized void passwordChange(String string, @Blind String string2, @Blind String string3) throws SQLException, IOException {
        this.ociPasswordChange(string, string2, string3);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.lifecycle == 2 || this.lifecycle == 4 || this.aliasing) {
            return;
        }
        super.close();
        this.ociConnectionPool.connectionClosed((oracle.jdbc.oci.OracleOCIConnection)this);
    }

    public synchronized void setConnectionPool(OracleOCIConnectionPool oracleOCIConnectionPool) {
        this.ociConnectionPool = oracleOCIConnectionPool;
    }

    @Override
    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        super.setStmtCacheSize(n2, bl);
    }

    static {
        try {
            $$$methodRef$$$6 = OracleOCIConnection.class.getDeclaredConstructor(String.class, Properties.class, OracleDriverExtension.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleOCIConnection.class.getDeclaredConstructor(String.class, Properties.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleOCIConnection.class.getDeclaredMethod("setStmtCacheSize", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleOCIConnection.class.getDeclaredMethod("setConnectionPool", OracleOCIConnectionPool.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleOCIConnection.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleOCIConnection.class.getDeclaredMethod("passwordChange", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleOCIConnection.class.getDeclaredMethod("getConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

