/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Properties;
import java.util.logging.Logger;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.driver.FailoverManagerImpl;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;

@ProxyFor(value={Connection.class, OracleConnection.class, oracle.jdbc.internal.OracleConnection.class})
@ProxyLocale
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class NonTxnReplayableConnection
extends NonTxnReplayableBase
implements Replayable,
ReplayableConnection {
    OracleConnectionBuilderImpl originalConnectionBuilder;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pre
    @Methods(signatures={@Signature(name="commit", args={}), @Signature(name="commit", args={EnumSet.class}), @Signature(name="rollback", args={}), @Signature(name="rollback", args={Savepoint.class}), @Signature(name="setSavepoint", args={}), @Signature(name="setSavepoint", args={String.class}), @Signature(name="releaseSavepoint", args={Savepoint.class}), @Signature(name="oracleRollback", args={OracleSavepoint.class}), @Signature(name="oracleSetSavepoint", args={}), @Signature(name="oracleSetSavepoint", args={String.class}), @Signature(name="oracleReleaseSavepoint", args={OracleSavepoint.class})})
    protected void preForTxnControl(Method method, Object object, Object ... objectArray) {
        FailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle != FailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            return;
        }
        String string = method == null ? "NULL METHOD" : method.getName();
        if (this.failoverMngr != null) {
            boolean bl = false;
            try {
                oracle.jdbc.internal.OracleConnection oracleConnection = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
                EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
                if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                    bl = true;
                }
            }
            catch (SQLException sQLException) {
                bl = true;
            }
            finally {
                if (bl) {
                    this.failoverMngr.disableReplayInternal(method, 371, "Replay disabled because of active transaction", null);
                } else {
                    super.preForAll(method, object, objectArray);
                }
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        this.isClosedAndNoReplay = true;
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        this.failoverMngr.setReplayInitiationTimeout(n2);
    }

    @Override
    public void initialize(OracleDataSource oracleDataSource, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        FailoverManagerImpl failoverManagerImpl = (FailoverManagerImpl)FailoverManagerImpl.getFailoverManager(this, oracleDataSource);
        this.setFailoverManager(failoverManagerImpl);
        this.originalConnectionBuilder = oracleConnectionBuilderImpl;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.failoverMngr.beginRequest();
    }

    @Override
    public void endRequest() throws SQLException {
        this.failoverMngr.endRequest();
    }

    @Override
    public void disableReplay() throws SQLException {
        this.failoverMngr.disableReplay();
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public ARRAY createARRAY(String string, Object objectArray) throws SQLException {
        Object[] objectArray2;
        Object object;
        Object object2;
        if (objectArray != null && objectArray instanceof Object[]) {
            object2 = objectArray;
            if (((Object[])object2).length > 0) {
                object = new Object[((Object[])object2).length];
                int n2 = 0;
                for (Object object3 : object2) {
                    object[n2++] = object3 instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object3).getDelegate() : object3;
                }
                objectArray2 = object;
            } else {
                objectArray2 = objectArray;
            }
        } else {
            objectArray2 = objectArray;
        }
        object2 = null;
        try {
            object2 = oracle.jdbc.internal.OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        this.preForAll((Method)object2, this, string, objectArray2);
        try {
            object = (oracle.jdbc.internal.OracleConnection)this.getDelegate();
            ARRAY aRRAY = object.createARRAY(string, objectArray2);
            return (ARRAY)this.postForAll((Method)object2, aRRAY);
        }
        catch (SQLException sQLException) {
            return (ARRAY)this.postForAll((Method)object2, this.onErrorForAll((Method)object2, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.createARRAY(string, object);
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        Method method = null;
        try {
            method = Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Array array = connection.createArrayOf(string, objectArray2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof NonTxnReplayableBase ? ((NonTxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        Method method = null;
        try {
            method = Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exception) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Struct struct = connection.createStruct(string, objectArray2);
            return (Struct)this.postForAll(method, struct);
        }
        catch (SQLException sQLException) {
            return (Struct)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Blob createBlob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Clob createClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract NClob createNClob() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract SQLXML createSQLXML() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract Statement createStatement(int var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract CallableStatement prepareCall(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, int var2, int var3, int var4) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE_CACHE)
    public abstract PreparedStatement prepareStatement(String var1, String[] var2) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract Savepoint setSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return (T)this.getDelegate();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public abstract Connection _getPC();

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint() throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.CREATE)
    public abstract OracleSavepoint oracleSetSavepoint(String var1) throws SQLException;

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public OracleConnection unwrap() {
        return ((oracle.jdbc.internal.OracleConnection)this.getDelegate()).unwrap();
    }

    static {
        try {
            $$$methodRef$$$21 = NonTxnReplayableConnection.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$20 = NonTxnReplayableConnection.class.getDeclaredMethod("unwrap", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = NonTxnReplayableConnection.class.getDeclaredMethod("unwrap", Class.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = NonTxnReplayableConnection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = NonTxnReplayableConnection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = NonTxnReplayableConnection.class.getDeclaredMethod("createOracleArray", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = NonTxnReplayableConnection.class.getDeclaredMethod("createARRAY", String.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = NonTxnReplayableConnection.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = NonTxnReplayableConnection.class.getDeclaredMethod("endRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = NonTxnReplayableConnection.class.getDeclaredMethod("beginRequest", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = NonTxnReplayableConnection.class.getDeclaredMethod("initialize", OracleDataSource.class, OracleConnectionBuilderImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = NonTxnReplayableConnection.class.getDeclaredMethod("setReplayInitiationTimeout", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = NonTxnReplayableConnection.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = NonTxnReplayableConnection.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = NonTxnReplayableConnection.class.getDeclaredMethod("postForCancel", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = NonTxnReplayableConnection.class.getDeclaredMethod("postForClosure", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = NonTxnReplayableConnection.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = NonTxnReplayableConnection.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = NonTxnReplayableConnection.class.getDeclaredMethod("preForCancel", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = NonTxnReplayableConnection.class.getDeclaredMethod("preForClosure", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = NonTxnReplayableConnection.class.getDeclaredMethod("preForTxnControl", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = NonTxnReplayableConnection.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

