/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.HashSet;
import java.util.logging.Logger;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.AdditionalDatabaseMetaData;
import oracle.jdbc.internal.ClientDataSupport;
import oracle.jdbc.internal.OracleConcreteProxy;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.OracleParameterMetaData;
import oracle.jdbc.internal.OracleResultSetMetaData;
import oracle.jdbc.internal.OracleRowId;
import oracle.jdbc.internal.OracleSavepoint;
import oracle.jdbc.internal.OracleTypeMetaData;
import oracle.jdbc.internal.ReplayContext;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;

@ProxyFor(value={AdditionalDatabaseMetaData.class, ClientDataSupport.class, OracleParameterMetaData.class, OracleRowId.class, OracleSavepoint.class, OracleTypeMetaData.class, OracleTypeMetaData.Array.class, OracleTypeMetaData.Opaque.class, OracleTypeMetaData.Struct.class, OracleResultSetMetaData.class})
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableBase
implements JDBCReplayable {
    protected TxnFailoverManagerImpl failoverMngr;
    protected TxnFailoverManagerImpl.CallHistoryEntry headSameProxy = null;
    protected TxnFailoverManagerImpl.CallHistoryEntry tailSameProxy = null;
    protected TxnFailoverManagerImpl.CallHistoryEntry replayingCallEntry = null;
    protected SQLRecoverableException originalError = null;
    protected static final int SPECIAL_SVR_RECOVERABLE_ERROR = 603;
    protected static final int TXN_IN_READONLY_REPLAY_ERROR = 29791;
    protected static final int SET_CONTAINER_AFTER_PREPARE = 44787;
    protected static final int SVR_NO_REPLAY_ERROR_CODE = 45;
    protected boolean isClosedAndNoReplay = false;
    protected boolean isLogicallyClosed = false;
    protected boolean abortCalledBeforeLatestClose = false;
    protected boolean isCreatingCallReplayable = true;
    protected boolean isCurrentExecuteReplayable = true;
    protected boolean isProxyReplayable = true;
    protected TxnFailoverManagerImpl.CallHistoryEntry creatorCallEntry = null;
    protected long currentBindChecksum = 0L;
    private static final String PROXY_CLASS_SUFFIX = "$$$Proxy";
    protected String thisProxyNameInLog = "";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    protected TxnReplayableBase() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        int n2 = stringBuffer.indexOf(PROXY_CLASS_SUFFIX);
        stringBuffer.delete(0, n2);
        stringBuffer.append("@");
        stringBuffer.append(Integer.toHexString(this.hashCode()));
        this.thisProxyNameInLog = stringBuffer.toString();
    }

    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: {
                this.failoverMngr.acStatistics.incrementTotalCalls();
                this.failoverMngr.record(this, method, objectArray, "started");
                break;
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                this.failoverMngr.acStatistics.incrementTotalCalls();
            }
        }
    }

    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Post
    protected Object postForAll(Method method, Object object) {
        Object object2;
        if (object instanceof TxnReplayableBase) {
            object2 = (TxnReplayableBase)object;
            ((TxnReplayableBase)object2).setFailoverManager(this.getFailoverManager());
        }
        object2 = this.failoverMngr.getReplayLifecycle();
        switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[((Enum)object2).ordinal()]) {
            case 1: 
            case 8: {
                this.doPostWhenRecording(method, object, null);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                this.doPostWhenReplaying(method, object, null);
            }
        }
        return object;
    }

    protected void doPostWhenRecording(Method method, Object object, SQLException sQLException) {
        this.failoverMngr.update(this, null, object, "completed", this.currentBindChecksum, sQLException);
        this.currentBindChecksum = 0L;
    }

    protected void doPostWhenReplaying(Method method, Object object, SQLException sQLException) {
    }

    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        this.onErrorForAll(method, sQLException);
    }

    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        Object object;
        TxnReplayableBase txnReplayableBase = (TxnReplayableBase)this.failoverMngr.getConnectionProxy();
        OracleConnection oracleConnection = (OracleConnection)txnReplayableBase.getDelegate();
        txnReplayableBase.abortCalledBeforeLatestClose = false;
        if (txnReplayableBase.isClosedAndNoReplay) {
            throw sQLException;
        }
        if (oracleConnection.isClosed() && oracleConnection.isSafelyClosed()) {
            throw sQLException;
        }
        if (sQLException instanceof BatchUpdateException) {
            object = sQLException.getNextException();
            if (object != null && object instanceof SQLRecoverableException) {
                sQLException = object;
            }
        }
        if (sQLException instanceof SQLRecoverableException && !this.isLogicallyClosed) {
            if (!this.failoverMngr.isSessionStateConsistencyDynamic() && !this.isCreatingCallReplayable) {
                this.failoverMngr.disableReplayAndThrowOriginalError(method, 372, "Replay disabled because of nonreplayable call", (SQLRecoverableException)sQLException);
            }
            object = this.failoverMngr.getReplayLifecycle();
            switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[((Enum)object).ordinal()]) {
                case 1: {
                    this.failoverMngr.update(this, null, null, "incomplete", this.currentBindChecksum, sQLException);
                    this.currentBindChecksum = 0L;
                }
                case 3: 
                case 4: 
                case 5: {
                    return this.failoverMngr.handleOutage(method, (SQLRecoverableException)sQLException);
                }
                case 8: {
                    this.failoverMngr.update(this, null, null, "incomplete", this.currentBindChecksum, sQLException);
                    this.currentBindChecksum = 0L;
                }
            }
            throw sQLException;
        }
        if (sQLException instanceof SQLRecoverableException && !this.failoverMngr.isSessionStateConsistencyDynamic() && !this.isCreatingCallReplayable) {
            this.failoverMngr.disableReplayAndThrowOriginalError(method, 372, "Replay disabled because of nonreplayable call", (SQLRecoverableException)sQLException);
        }
        if (sQLException instanceof SQLException && sQLException.getErrorCode() == 45) {
            this.failoverMngr.disableReplayAndThrowSQLException(method, 398, "Replay disabled because server killed session with -noreplay option", sQLException);
        }
        object = this.failoverMngr.getReplayLifecycle();
        switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[((Enum)object).ordinal()]) {
            case 1: 
            case 8: {
                this.doPostWhenRecording(method, null, sQLException);
                break;
            }
        }
        throw sQLException;
    }

    @Pre
    @Methods(signatures={@Signature(name="toString", args={})})
    protected void preForToString(Method method, Object object, Object ... objectArray) {
    }

    @Post
    @Methods(signatures={@Signature(name="toString", args={})})
    protected String postForToString(Method method, String string) {
        return string;
    }

    @GetDelegate
    protected abstract Object getDelegate();

    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @GetCreator
    protected abstract Object getCreator();

    @Override
    public Object replayOneCall(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object;
        Object object2 = null;
        String string = ((TxnReplayableBase)callHistoryEntry.jdbcProxy).thisProxyNameInLog;
        try {
            Object object3;
            Object object4;
            ((JDBCReplayable)callHistoryEntry.jdbcProxy).setReplayingCallContext(callHistoryEntry, sQLRecoverableException);
            if (callHistoryEntry.replayContext != null) {
                object = (TxnReplayableBase)this.failoverMngr.getConnectionProxy();
                object4 = (OracleConnection)((TxnReplayableBase)object).getDelegate();
                object4.setReplayContext(callHistoryEntry.replayContext);
                for (ReplayContext replayContext : callHistoryEntry.replayContext) {
                    if (replayContext != null) continue;
                }
            }
            object2 = object = callHistoryEntry.method.invoke(callHistoryEntry.jdbcProxy, callHistoryEntry.args);
            if (object instanceof TxnReplayableBase) {
                object4 = this.failoverMngr.getReplayLifecycle();
                if (object4 == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING && object != null && callHistoryEntry.result != null) {
                    object3 = ((TxnReplayableBase)object).getDelegate();
                    ((TxnReplayableBase)callHistoryEntry.result).setDelegate(object3);
                    object2 = callHistoryEntry.result;
                }
            } else if (object instanceof OracleConcreteProxy && (object4 = this.failoverMngr.getReplayLifecycle()) == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING && object != null && callHistoryEntry.result != null && callHistoryEntry.result instanceof OracleConcreteProxy) {
                object3 = ((OracleConcreteProxy)object).getConcreteProxy();
                TxnReplayableBase txnReplayableBase = ((OracleConcreteProxy)callHistoryEntry.result).getConcreteProxy();
                if (object3 != null && txnReplayableBase != null) {
                    Object object5 = ((TxnReplayableBase)object3).getDelegate();
                    txnReplayableBase.setDelegate(object5);
                    object2 = callHistoryEntry.result;
                } else if (object3 == null && txnReplayableBase != null) {
                    txnReplayableBase.setDelegate(object);
                    object2 = callHistoryEntry.result;
                }
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            SQLException sQLException;
            Throwable throwable = invocationTargetException.getCause();
            if (throwable instanceof BatchUpdateException && (sQLException = ((BatchUpdateException)throwable).getNextException()) != null && sQLException instanceof SQLRecoverableException) {
                throwable = sQLException;
            }
            if (throwable instanceof SQLRecoverableException && !this.isLogicallyClosed) {
                int n2;
                sQLException = (SQLRecoverableException)throwable;
                Throwable throwable2 = sQLException.getCause();
                if (throwable2 == null && (n2 = sQLException.getErrorCode()) == 603) {
                    if (sQLException.getMessage().indexOf("ORA-29791") != -1) {
                        sQLRecoverableException.setNextException(sQLException);
                        this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 390, "Replay failed because of active transaction during replay", sQLRecoverableException);
                    } else if (sQLException.getMessage().indexOf("ORA-44787") != -1) {
                        sQLRecoverableException.setNextException(sQLException);
                        this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 366, "Replay failed because of calling set container after PREPARE_REPLAY", sQLRecoverableException);
                    }
                }
                throw sQLException;
            }
            if (throwable instanceof SQLRecoverableException && this.isLogicallyClosed || throwable instanceof SQLException) {
                sQLException = (SQLException)throwable;
                TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
                if (sQLException.getErrorCode() == 17290) {
                    throw sQLException;
                }
                if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED && this.failoverMngr.didReplayingLastCallDisableReplay) {
                    throw sQLException;
                }
                if (throwable instanceof SQLException && (callHistoryEntry.callException == null || sQLException.getErrorCode() != callHistoryEntry.callException.getErrorCode())) {
                    sQLRecoverableException.setNextException(sQLException);
                    this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 389, "Replay failed because of error code or message mismatch", sQLRecoverableException);
                } else if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.REPLAYING_LASTCALL) {
                    throw sQLException;
                }
            } else {
                this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 370, "Replay disabled", sQLRecoverableException);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.failoverMngr.disableReplayAndThrowException(callHistoryEntry.method, 370, "Replay disabled", sQLRecoverableException);
        }
        object = this.failoverMngr.getReplayLifecycle();
        switch (1.$SwitchMap$oracle$jdbc$replay$driver$TxnFailoverManagerImpl$ReplayLifecycle[((Enum)object).ordinal()]) {
            case 2: 
            case 4: {
                this.failoverMngr.throwReplayExceptionInternal(0, null, null);
            }
        }
        return object2;
    }

    @Override
    public void addToSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry) {
        callHistoryEntry.prevEntrySameProxy = this.tailSameProxy;
        callHistoryEntry.nextEntrySameProxy = null;
        if (this.tailSameProxy != null) {
            this.tailSameProxy.nextEntrySameProxy = callHistoryEntry;
        }
        this.tailSameProxy = callHistoryEntry;
        if (this.headSameProxy == null) {
            this.headSameProxy = callHistoryEntry;
        }
    }

    @Override
    public void removeFromSameProxyList(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry) {
        if (callHistoryEntry.nextEntrySameProxy != null) {
            callHistoryEntry.nextEntrySameProxy.prevEntrySameProxy = callHistoryEntry.prevEntrySameProxy;
        }
        if (callHistoryEntry.prevEntrySameProxy != null) {
            callHistoryEntry.prevEntrySameProxy.nextEntrySameProxy = callHistoryEntry.nextEntrySameProxy;
        }
        if (this.headSameProxy == callHistoryEntry) {
            this.headSameProxy = callHistoryEntry.nextEntrySameProxy;
        }
        if (this.tailSameProxy == callHistoryEntry) {
            this.tailSameProxy = callHistoryEntry.prevEntrySameProxy;
        }
    }

    @Override
    public void purgeSameProxyList() {
        if (this.failoverMngr != null) {
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Object object = this; object != null && object instanceof TxnReplayableBase && !(object instanceof ReplayableConnection); object = ((TxnReplayableBase)object).getCreator()) {
                hashSet.add(object);
            }
            this.failoverMngr.purgeForSameProxy(hashSet, this.headSameProxy);
        }
    }

    @Override
    public void setReplayingCallContext(TxnFailoverManagerImpl.CallHistoryEntry callHistoryEntry, SQLRecoverableException sQLRecoverableException) {
        this.replayingCallEntry = callHistoryEntry;
        this.originalError = sQLRecoverableException;
    }

    @Override
    public synchronized void setFailoverManager(TxnFailoverManagerImpl txnFailoverManagerImpl) {
        this.failoverMngr = txnFailoverManagerImpl;
    }

    @Override
    public synchronized TxnFailoverManagerImpl getFailoverManager() {
        return this.failoverMngr;
    }

    public void disableReplay() throws SQLException {
        if (this.failoverMngr != null) {
            this.failoverMngr.disableReplay();
        }
    }

    private boolean isReplayFailure(Throwable throwable) {
        int n2;
        boolean bl = false;
        if (throwable instanceof SQLException && (n2 = ((SQLException)throwable).getErrorCode()) >= 370 && n2 < 400) {
            bl = true;
        }
        return bl;
    }

    protected boolean assertThrowablesMatch(Throwable throwable, Throwable throwable2) {
        boolean bl;
        boolean bl2 = throwable2 == null ? false : throwable.getClass().getName().equals(throwable2.getClass().getName());
        if (throwable instanceof SQLException && bl2) {
            bl = ((SQLException)throwable).getErrorCode() == ((SQLException)throwable2).getErrorCode();
        } else if (bl2) {
            String string = throwable.getMessage();
            String string2 = throwable2.getMessage();
            bl = string == null && string2 == null || string != null && string2 != null && throwable.getMessage().equals(throwable2.getMessage());
        } else {
            bl = false;
        }
        return bl;
    }

    @DisableTrace
    public String toString() {
        return this.getDelegate().toString();
    }

    public Object getDelegateObj() {
        return this.getDelegate();
    }

    static {
        try {
            $$$methodRef$$$20 = TxnReplayableBase.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$19 = TxnReplayableBase.class.getDeclaredMethod("getDelegateObj", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$18 = TxnReplayableBase.class.getDeclaredMethod("assertThrowablesMatch", Throwable.class, Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$17 = TxnReplayableBase.class.getDeclaredMethod("isReplayFailure", Throwable.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$16 = TxnReplayableBase.class.getDeclaredMethod("disableReplay", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$15 = TxnReplayableBase.class.getDeclaredMethod("getFailoverManager", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$14 = TxnReplayableBase.class.getDeclaredMethod("setFailoverManager", TxnFailoverManagerImpl.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$13 = TxnReplayableBase.class.getDeclaredMethod("setReplayingCallContext", TxnFailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$12 = TxnReplayableBase.class.getDeclaredMethod("purgeSameProxyList", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$11 = TxnReplayableBase.class.getDeclaredMethod("removeFromSameProxyList", TxnFailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$10 = TxnReplayableBase.class.getDeclaredMethod("addToSameProxyList", TxnFailoverManagerImpl.CallHistoryEntry.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$9 = TxnReplayableBase.class.getDeclaredMethod("replayOneCall", TxnFailoverManagerImpl.CallHistoryEntry.class, SQLRecoverableException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$8 = TxnReplayableBase.class.getDeclaredMethod("postForToString", Method.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$7 = TxnReplayableBase.class.getDeclaredMethod("preForToString", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$6 = TxnReplayableBase.class.getDeclaredMethod("onErrorForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$5 = TxnReplayableBase.class.getDeclaredMethod("onErrorVoidForAll", Method.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$4 = TxnReplayableBase.class.getDeclaredMethod("doPostWhenReplaying", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$3 = TxnReplayableBase.class.getDeclaredMethod("doPostWhenRecording", Method.class, Object.class, SQLException.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$2 = TxnReplayableBase.class.getDeclaredMethod("postForAll", Method.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$1 = TxnReplayableBase.class.getDeclaredMethod("postForAll", Method.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
        try {
            $$$methodRef$$$0 = TxnReplayableBase.class.getDeclaredMethod("preForAll", Method.class, Object.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc.internal.replay");
    }
}

