/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Executable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.ROWSET})
public class OracleRow
implements Serializable,
Cloneable {
    private Object[] column;
    private Object[] changedColumn;
    private boolean[] isOriginalNull;
    private byte[] columnChangeFlag;
    private int noColumn = 0;
    private int noColumnsInserted;
    private boolean rowDeleted = false;
    private boolean rowInserted = false;
    private static final byte COLUMN_CHANGED = 17;
    private boolean rowUpdated = false;
    long[][] columnTypeInfo;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;

    public OracleRow(int n2) {
        this.noColumn = n2;
        this.column = new Object[n2];
        this.changedColumn = new Object[n2];
        this.columnChangeFlag = new byte[n2];
        this.isOriginalNull = new boolean[n2];
        this.columnTypeInfo = new long[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.columnChangeFlag[i2] = 0;
        }
    }

    public OracleRow(int n2, boolean bl) {
        this(n2);
        this.rowInserted = bl;
        this.noColumnsInserted = 0;
    }

    public OracleRow(int n2, Object[] objectArray) {
        this(n2);
        System.arraycopy(objectArray, 0, this.column, 0, n2);
    }

    public void setColumnValue(int n2, Object object) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.column[n2 - 1] = object;
    }

    void markOriginalNull(int n2, boolean bl) throws SQLException {
        this.isOriginalNull[n2 - 1] = bl;
    }

    boolean isOriginalNull(int n2) throws SQLException {
        return this.isOriginalNull[n2 - 1];
    }

    public void updateObject(int n2, Object object) {
        this.updateObject(n2, object, null);
    }

    void updateObject(int n2, Object object, long[] lArray) {
        if (this.rowInserted) {
            ++this.noColumnsInserted;
        }
        this.columnChangeFlag[n2 - 1] = 17;
        this.changedColumn[n2 - 1] = object;
        this.columnTypeInfo[n2 - 1] = lArray;
    }

    public void cancelRowUpdates() {
        this.noColumnsInserted = 0;
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            this.columnChangeFlag[i2] = 0;
        }
        this.changedColumn = null;
        this.changedColumn = new Object[this.noColumn];
    }

    public Object getColumn(int n2) {
        return this.column[n2 - 1];
    }

    public Object getModifiedColumn(int n2) {
        return this.changedColumn[n2 - 1];
    }

    public boolean isColumnChanged(int n2) {
        return this.columnChangeFlag[n2 - 1] == 17;
    }

    public boolean isRowUpdated() {
        if (this.rowInserted || this.rowDeleted) {
            return false;
        }
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            if (this.columnChangeFlag[i2] != 17) continue;
            return true;
        }
        return false;
    }

    public void setRowUpdated(boolean bl) {
        this.rowUpdated = bl;
        if (!bl) {
            this.cancelRowUpdates();
        }
    }

    public boolean isRowInserted() {
        return this.rowInserted;
    }

    public void cancelRowDeletion() {
        this.rowDeleted = false;
    }

    public void setRowDeleted(boolean bl) {
        this.rowDeleted = bl;
    }

    public boolean isRowDeleted() {
        return this.rowDeleted;
    }

    public Object[] getOriginalRow() {
        return this.column;
    }

    public boolean isRowFullyPopulated() {
        if (!this.rowInserted) {
            return false;
        }
        return this.noColumnsInserted == this.noColumn;
    }

    public void setInsertedFlag(boolean bl) {
        this.rowInserted = bl;
    }

    void makeUpdatesOriginal() {
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            if (this.columnChangeFlag[i2] != 17) continue;
            this.column[i2] = this.changedColumn[i2];
            this.changedColumn[i2] = null;
            this.columnChangeFlag[i2] = 0;
        }
        this.rowUpdated = false;
    }

    public void insertRow() {
        this.columnChangeFlag = null;
        this.columnChangeFlag = new byte[this.noColumn];
        System.arraycopy(this.changedColumn, 0, this.column, 0, this.noColumn);
        this.changedColumn = null;
        this.changedColumn = new Object[this.noColumn];
    }

    public Collection toCollection() {
        Vector<Object> vector = new Vector<Object>(this.noColumn);
        for (int i2 = 1; i2 <= this.noColumn; ++i2) {
            vector.add(this.isColumnChanged(i2) ? this.getModifiedColumn(i2) : this.getColumn(i2));
        }
        return vector;
    }

    public OracleRow createCopy() throws SQLException {
        OracleRow oracleRow = new OracleRow(this.noColumn);
        for (int i2 = 0; i2 < this.noColumn; ++i2) {
            oracleRow.column[i2] = this.getCopy(this.column[i2]);
            oracleRow.changedColumn[i2] = this.getCopy(this.changedColumn[i2]);
        }
        System.arraycopy(this.columnChangeFlag, 0, oracleRow.columnChangeFlag, 0, this.noColumn);
        oracleRow.noColumnsInserted = this.noColumnsInserted;
        oracleRow.rowDeleted = this.rowDeleted;
        oracleRow.rowInserted = this.rowInserted;
        oracleRow.rowUpdated = this.rowUpdated;
        return oracleRow;
    }

    public Object getCopy(Object object) throws SQLException {
        Object object2;
        block9: {
            object2 = null;
            try {
                if (object == null) {
                    return null;
                }
                if (object instanceof String) {
                    object2 = (String)object;
                    break block9;
                }
                if (object instanceof Number) {
                    object2 = new BigDecimal(((Number)object).toString());
                    break block9;
                }
                if (object instanceof Date) {
                    object2 = new Date(((Date)object).getTime());
                    break block9;
                }
                if (object instanceof Timestamp) {
                    object2 = new Timestamp(((Timestamp)object).getTime());
                    break block9;
                }
                if (object instanceof InputStream) {
                    object2 = new DataInputStream((InputStream)object);
                    break block9;
                }
                if (object instanceof OutputStream) {
                    object2 = new DataOutputStream((OutputStream)object);
                    break block9;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 348, object.getClass().getName()).fillInStackTrace();
            }
            catch (Exception exception) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 349, object.getClass().getName() + exception.getMessage()).fillInStackTrace();
            }
        }
        return object2;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return this.createCopy();
        }
        catch (SQLException sQLException) {
            throw new CloneNotSupportedException("Error while cloning\n" + sQLException.getMessage());
        }
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    static {
        try {
            $$$methodRef$$$27 = OracleRow.class.getDeclaredConstructor(Integer.TYPE, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = OracleRow.class.getDeclaredConstructor(Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = OracleRow.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = OracleRow.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = OracleRow.class.getDeclaredMethod("clone", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = OracleRow.class.getDeclaredMethod("getCopy", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = OracleRow.class.getDeclaredMethod("createCopy", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OracleRow.class.getDeclaredMethod("toCollection", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OracleRow.class.getDeclaredMethod("insertRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OracleRow.class.getDeclaredMethod("makeUpdatesOriginal", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OracleRow.class.getDeclaredMethod("setInsertedFlag", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OracleRow.class.getDeclaredMethod("isRowFullyPopulated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OracleRow.class.getDeclaredMethod("getOriginalRow", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OracleRow.class.getDeclaredMethod("isRowDeleted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OracleRow.class.getDeclaredMethod("setRowDeleted", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OracleRow.class.getDeclaredMethod("cancelRowDeletion", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OracleRow.class.getDeclaredMethod("isRowInserted", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OracleRow.class.getDeclaredMethod("setRowUpdated", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OracleRow.class.getDeclaredMethod("isRowUpdated", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OracleRow.class.getDeclaredMethod("isColumnChanged", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OracleRow.class.getDeclaredMethod("getModifiedColumn", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OracleRow.class.getDeclaredMethod("getColumn", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OracleRow.class.getDeclaredMethod("cancelRowUpdates", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OracleRow.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class, long[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OracleRow.class.getDeclaredMethod("updateObject", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OracleRow.class.getDeclaredMethod("isOriginalNull", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OracleRow.class.getDeclaredMethod("markOriginalNull", Integer.TYPE, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OracleRow.class.getDeclaredMethod("setColumnValue", Integer.TYPE, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

