/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Collection;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.AvailableConnections;
import oracle.ucp.common.UniversalConnectionPoolImpl;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public abstract class AvailableConnectionsBase
implements AvailableConnections {
    private static final Logger logger = UCPLoggerFactory.createLogger(AvailableConnectionsBase.class.getCanonicalName());
    static final int INITIAL_CAPACITY = 256;
    private UniversalConnectionPoolImpl m_cp;

    public AvailableConnectionsBase(UniversalConnectionPoolImpl cp) throws UniversalConnectionPoolException {
        if (cp == null) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(54);
            logger.throwing(this.getClass().getName(), "AvailableConnectionsBase", ucpe);
            throw ucpe;
        }
        this.m_cp = cp;
    }

    public abstract Collection getAvailableConnections(ConnectionRetrievalInfo var1);

    public abstract boolean removeAvailableConnection(UniversalPooledConnection var1);

    public abstract UniversalPooledConnection removeAvailableConnection(ConnectionRetrievalInfo var1);

    public abstract UniversalPooledConnection removeAvailableConnection();

    public abstract void addAvailableConnection(UniversalPooledConnection var1);

    public abstract void closeAllConnections();

    public abstract int getNumAvailableConnections();

    public abstract int getNumAvailableLabeledConnections();

    public void closeAvailableConnection() {
        UniversalPooledConnection pooledConnection = this.removeAvailableConnection();
        if (pooledConnection != null) {
            this.m_cp.closePhysicalConnection(pooledConnection.getPhysicalConnection());
            logger.finest("closed available connection" + pooledConnection.toString());
        }
    }

    protected UniversalConnectionPoolImpl getConnectionPool() {
        return this.m_cp;
    }

    public abstract UniversalPooledConnection[] getAllAvailableConnections();

    protected void closeAvailableConnection(Object connection) {
        this.m_cp.closePhysicalConnection(connection);
    }

    protected void notifyAvailable(ConnectionRetrievalInfo cri) {
        this.m_cp.m_borrowRequestQueue.notifyAvailable(cri);
    }
}

