/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.AvailableConnectionsManyCollections;
import oracle.ucp.common.UniversalConnectionPoolImpl;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class AvailableConnectionsManyCollectionsWithLabels
extends AvailableConnectionsManyCollections {
    private static final Logger logger = UCPLoggerFactory.createLogger(AvailableConnectionsManyCollectionsWithLabels.class.getCanonicalName());
    private final Map<ConnectionRetrievalInfo, Collection<UniversalPooledConnection>> m_availableLabeledConnections = new HashMap<ConnectionRetrievalInfo, Collection<UniversalPooledConnection>>(256);
    private int m_numAvailableLabeledConnections = 0;

    public AvailableConnectionsManyCollectionsWithLabels(UniversalConnectionPoolImpl cp) throws UniversalConnectionPoolException {
        super(cp);
    }

    private Collection createAvailableConnectionsCollection(ConnectionRetrievalInfo connectionRequestInfo) {
        Collection connections = this.getConnectionPool().createCollection();
        this.m_availableLabeledConnections.put(connectionRequestInfo, connections);
        logger.finest("available connections collection created");
        return connections;
    }

    public synchronized Collection getAvailableConnections(ConnectionRetrievalInfo connectionRetrievalInfo) {
        if (connectionRetrievalInfo.getLabels() == null) {
            return super.getAvailableConnections(connectionRetrievalInfo);
        }
        Collection connections = this.m_availableLabeledConnections.get(connectionRetrievalInfo);
        if (connections == null) {
            connections = this.createAvailableConnectionsCollection(connectionRetrievalInfo);
        }
        logger.finest("available connections: " + connections.size());
        return connections;
    }

    public synchronized void addAvailableConnection(UniversalPooledConnection connection) {
        ConnectionRetrievalInfo cri = connection.getConnectionRetrievalInfo();
        if (cri.getLabels() == null) {
            super.addAvailableConnection(connection);
            return;
        }
        Collection connections = this.m_availableLabeledConnections.get(cri);
        if (connections == null) {
            connections = this.createAvailableConnectionsCollection(cri);
            logger.finest("available conections collection created");
        }
        if (connections.add((UniversalPooledConnection)connection)) {
            ++this.m_numAvailableLabeledConnections;
            this.notifyAvailable(cri);
            logger.finest("available conection added");
        }
    }

    public synchronized boolean removeAvailableConnection(UniversalPooledConnection connection) {
        ConnectionRetrievalInfo cri = connection.getConnectionRetrievalInfo();
        if (cri.getLabels() == null) {
            return super.removeAvailableConnection(connection);
        }
        Collection<UniversalPooledConnection> connections = this.m_availableLabeledConnections.get(cri);
        if (connections != null && connections.remove(connection)) {
            --this.m_numAvailableLabeledConnections;
            logger.finest("available connection removed");
            return true;
        }
        return false;
    }

    public synchronized UniversalPooledConnection removeAvailableConnection(ConnectionRetrievalInfo connectionRetrievalInfo) {
        if (connectionRetrievalInfo.getLabels() == null) {
            return super.removeAvailableConnection(connectionRetrievalInfo);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllConnections() {
        UniversalPooledConnection[] connsToClose;
        AvailableConnectionsManyCollectionsWithLabels availableConnectionsManyCollectionsWithLabels = this;
        synchronized (availableConnectionsManyCollectionsWithLabels) {
            connsToClose = this.getAllAvailableConnections();
            this.m_availableLabeledConnections.clear();
            this.m_availableConnections.clear();
            this.m_numAvailableLabeledConnections = 0;
            this.m_numAvailableConnections = 0;
        }
        UniversalConnectionPoolImpl cp = this.getConnectionPool();
        for (int i = 0; i < connsToClose.length; ++i) {
            cp.closePhysicalConnection(connsToClose[i].getPhysicalConnection());
        }
        logger.finest("all conections closed");
    }

    public synchronized int getNumAvailableConnections() {
        return this.m_numAvailableLabeledConnections + super.getNumAvailableConnections();
    }

    public synchronized int getNumAvailableLabeledConnections() {
        return this.m_numAvailableLabeledConnections;
    }

    public synchronized UniversalPooledConnection[] getAllAvailableConnections() {
        UniversalPooledConnection[] connections = new UniversalPooledConnection[this.getNumAvailableConnections()];
        int i = 0;
        for (Collection collection : this.m_availableConnections.values()) {
            for (UniversalPooledConnection conn : collection) {
                connections[i++] = conn;
            }
        }
        for (Collection collection : this.m_availableLabeledConnections.values()) {
            for (UniversalPooledConnection conn : collection) {
                connections[i++] = conn;
            }
        }
        logger.log(Level.FINEST, "available conections: {0}", connections.length);
        return connections;
    }
}

