/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.jdbc.oracle.OracleDatabaseInstanceInfo;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

class OracleConnectionAffinityContext
implements Serializable,
Cloneable {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleConnectionAffinityContext.class.getCanonicalName());
    public static String DEFAULT_VERSION_NUMBER = "1.0";
    public static String DEFAULT_SERVICE_NAME = null;
    public static String DEFAULT_DATATBASE_UNIQ_NAME = null;
    public static String DEFAULT_INSTANCE_NAME = null;
    public static String DEFAULT_CONNECTIONPOOL_ID = null;
    public static String DEFAULT_CONNECTION_ID = null;
    private String m_versionNumber = DEFAULT_VERSION_NUMBER;
    private String m_serviceName = DEFAULT_SERVICE_NAME;
    private String m_dbUniqName = DEFAULT_DATATBASE_UNIQ_NAME;
    private String m_instanceName = DEFAULT_INSTANCE_NAME;
    private String m_connectionPoolID = DEFAULT_CONNECTIONPOOL_ID;
    private boolean m_isForInstanceAffinity = false;

    OracleConnectionAffinityContext() {
        this.m_versionNumber = DEFAULT_VERSION_NUMBER;
        this.m_serviceName = DEFAULT_SERVICE_NAME;
        this.m_dbUniqName = DEFAULT_DATATBASE_UNIQ_NAME;
        this.m_instanceName = DEFAULT_INSTANCE_NAME;
        this.m_connectionPoolID = DEFAULT_CONNECTIONPOOL_ID;
        this.m_isForInstanceAffinity = false;
    }

    OracleConnectionAffinityContext(OracleDatabaseInstanceInfo dbInfo, String poolName) {
        this.m_versionNumber = DEFAULT_VERSION_NUMBER;
        this.m_serviceName = dbInfo.serviceName;
        this.m_dbUniqName = dbInfo.getDatabaseName();
        this.m_instanceName = dbInfo.getInstanceName();
        this.m_connectionPoolID = poolName;
        this.m_isForInstanceAffinity = false;
    }

    public void setVersionNumber(String versionNumber) {
        logger.log(Level.FINEST, "versionNumber: {0}", versionNumber);
        this.m_versionNumber = versionNumber;
    }

    public String getVersionNumber() {
        return this.m_versionNumber;
    }

    public void setServiceName(String serviceName) {
        logger.log(Level.FINEST, "serviceName: {0}", serviceName);
        this.m_serviceName = serviceName;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setDatabaseUniqueName(String dbUniqname) {
        logger.log(Level.FINEST, "databaseUniqueName: {0}", dbUniqname);
        this.m_dbUniqName = dbUniqname;
    }

    public String getDatabaseUniqueName() {
        return this.m_dbUniqName;
    }

    public void setInstanceName(String instanceName) {
        logger.log(Level.FINEST, "instanceName: {0}", instanceName);
        this.m_instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.m_instanceName;
    }

    public void setConnectionPoolID(String poolID) {
        logger.log(Level.FINEST, "connectionPoolID: {0}", poolID);
        this.m_connectionPoolID = poolID;
    }

    public String getConnectionPoolID() {
        return this.m_connectionPoolID;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OracleConnectionAffinityContext)) {
            return false;
        }
        OracleConnectionAffinityContext affinityContext = (OracleConnectionAffinityContext)obj;
        return this.isForInstanceAffinity() == affinityContext.isForInstanceAffinity() && Util.sameOrEqual(this.m_connectionPoolID, affinityContext.getConnectionPoolID()) && Util.sameOrEqual(this.m_serviceName, affinityContext.getServiceName()) && Util.sameOrEqual(this.m_dbUniqName, affinityContext.getDatabaseUniqueName()) && Util.sameOrEqual(this.m_instanceName, affinityContext.getInstanceName());
    }

    public int hashCode() {
        String result = this.m_connectionPoolID + "##" + this.m_serviceName + "##" + this.m_instanceName + "##" + this.m_dbUniqName + "##" + this.m_isForInstanceAffinity;
        return result.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + "Version: " + this.m_versionNumber + ", " + "Is For Instance Affinity: " + this.m_isForInstanceAffinity + ", " + "Pool Id: " + this.m_connectionPoolID + ", " + "Instance Name: " + this.m_instanceName + ", " + "DB Unique Name: " + this.m_dbUniqName + ", " + "Service Name: " + this.m_serviceName;
    }

    public Object clone() {
        OracleConnectionAffinityContext acopy = new OracleConnectionAffinityContext();
        acopy.setConnectionPoolID(this.m_connectionPoolID);
        acopy.setServiceName(this.m_serviceName);
        acopy.setDatabaseUniqueName(this.m_dbUniqName);
        acopy.setInstanceName(this.m_instanceName);
        acopy.setVersionNumber(this.m_versionNumber);
        acopy.setForInstanceAffinity(this.m_isForInstanceAffinity);
        return acopy;
    }

    void setForInstanceAffinity(boolean isForInstanceAffinity) {
        logger.log(Level.FINEST, "isForInstanceAffinity: {0}", isForInstanceAffinity);
        this.m_isForInstanceAffinity = isForInstanceAffinity;
    }

    boolean isForInstanceAffinity() {
        return this.m_isForInstanceAffinity;
    }
}

