/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.ConnectionPoolDataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class OraclePooledConnectionConnectionPool
extends OracleJDBCConnectionPool
implements ConnectionEventListener {
    private static final Logger logger = UCPLoggerFactory.createLogger(OraclePooledConnectionConnectionPool.class.getCanonicalName());

    public OraclePooledConnectionConnectionPool(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        super(connectionFactoryAdapter);
    }

    public PooledConnection getPooledConnection(JDBCConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        PooledConnection pc = (PooledConnection)this.borrowConnection(connectionRetrievalInfo).getPhysicalConnection();
        logger.finest("pooled connection was borrowed successfully");
        return pc;
    }

    public boolean returnPooledConnection(PooledConnection pooledConnection) throws UniversalConnectionPoolException {
        boolean ret = this.returnUsedPhysicalConnection(pooledConnection);
        logger.log(Level.FINE, "pooled connection was returned {0}successfully", ret ? "" : "un");
        return ret;
    }

    public boolean closePooledConnection(PooledConnection pooledConnection) throws UniversalConnectionPoolException {
        boolean ret = this.closeUsedPhysicalConnection(pooledConnection);
        logger.log(Level.FINE, "pooled connection was closed {0}successfully", ret ? "" : "un");
        return ret;
    }

    protected void validateConstructor(JDBCConnectionFactoryAdapter connectionFactoryAdapter) throws UniversalConnectionPoolException {
        if (!(connectionFactoryAdapter instanceof ConnectionPoolDataSourceConnectionFactoryAdapter)) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(105);
            logger.throwing(this.getClass().getName(), "validateConstructor", ucpe);
            throw ucpe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardConnection(ConnectionEvent event) {
        PooledConnection jdbcPooledConnection = (PooledConnection)event.getSource();
        if (jdbcPooledConnection != null) {
            jdbcPooledConnection.removeConnectionEventListener(this);
            OraclePooledConnectionConnectionPool oraclePooledConnectionConnectionPool = this;
            synchronized (oraclePooledConnectionConnectionPool) {
                this.discardUsedConnection(jdbcPooledConnection);
            }
        }
        logger.fine("pooled connection was discarded successfully");
    }

    public void connectionClosed(ConnectionEvent event) {
        logger.log(Level.FINEST, "Connection-closed event raised: {0}", event);
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        logger.log(Level.FINEST, "Connection-error event raised: {0}", event);
        this.discardConnection(event);
    }
}

