/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XADataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.XADataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class OracleXADataSourceConnectionFactoryAdapter
extends XADataSourceConnectionFactoryAdapter {
    private static final Logger logger = UCPLoggerFactory.createLogger(OracleXADataSourceConnectionFactoryAdapter.class.getCanonicalName());

    public OracleXADataSourceConnectionFactoryAdapter(XADataSource xaDataSource) throws UniversalConnectionPoolException {
        super(xaDataSource);
        this.initializeUrlFromConnectionFactory();
    }

    public UniversalPooledConnection createPooledConnection(Object connection, ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
        OracleUniversalPooledConnection pooledConnection = new OracleUniversalPooledConnection(jdbccp, connection, connectionRequestInfo, jdbccp.isFailoverEnabled());
        logger.log(Level.FINEST, "{0}, {1} returns {2}", new Object[]{connection, connectionRequestInfo, pooledConnection});
        return pooledConnection;
    }

    public void initializeUrlFromConnectionFactory() {
        Class<?> dsClass = this.m_xaDataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
            Method m = cls.getMethod("getURL", new Class[0]);
            this.m_url = (String)m.invoke((Object)this.m_xaDataSource, new Object[0]);
            logger.finest("initializeUrlFromConnectionFactory() succeeded");
        }
        catch (Exception exc) {
            logger.throwing(this.getClass().getName(), "initializeUrlFromConnectionFactory: ", exc);
        }
    }

    public void setUrl(String url) {
        Class<?> dsClass = this.m_xaDataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
            Method m = cls.getMethod("setURL", String.class);
            m.invoke((Object)this.m_xaDataSource, url);
            logger.log(Level.FINEST, "setUrl({0}) succeeded", url);
        }
        catch (Exception exc) {
            logger.throwing(this.getClass().getName(), "setUrl: ", exc);
        }
    }
}

