/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionHarvestingCallback;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;
import oracle.ucp.util.logging.UCPLoggerFactory;

abstract class JDBCConnectionProxyFactory
implements InvocationHandler,
LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection {
    private static final Logger logger = UCPLoggerFactory.createLogger(JDBCConnectionProxyFactory.class.getCanonicalName());
    protected Object m_proxiedConnection;
    protected JDBCUniversalPooledConnection m_jdbcPooledConnection;
    protected JDBCConnectionPool m_jdbcConnectionPool;
    protected Boolean m_closed = new Boolean(false);
    protected final long creationTS;
    private static final Map<String, SwitchTable> m_invokeSwitchTable = new HashMap<String, SwitchTable>();
    private static Map<Class, Class[]> m_mapKnownInterfaces;

    protected JDBCConnectionProxyFactory(Object proxiedConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        if (null == jdbcPooledConnection) {
            UCPErrorHandler.throwUniversalConnectionPoolException(150);
        }
        if (null == jdbcConnectionPool) {
            UCPErrorHandler.throwUniversalConnectionPoolException(54);
        }
        this.m_jdbcConnectionPool = jdbcConnectionPool;
        this.m_jdbcPooledConnection = jdbcPooledConnection;
        this.setProxiedConnection(proxiedConnection);
        this.creationTS = System.currentTimeMillis();
    }

    protected abstract void setProxiedConnection(Object var1) throws UniversalConnectionPoolException;

    protected abstract Object proxyInvokeAfterTargetInvoke(Object var1, String var2, Object var3) throws Throwable;

    protected Object proxyInvokeBeforeTargetInvoke(Object proxy, String methodName, Object[] args) throws Throwable {
        SwitchTable invokeSwitch = m_invokeSwitchTable.get(methodName);
        if (null == invokeSwitch) {
            invokeSwitch = SwitchTable._ABSENT;
        }
        switch (invokeSwitch) {
            case OBJECT_EQUALS: {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            case OBJECT_HASHCODE: {
                return new Integer(System.identityHashCode(proxy));
            }
            case OBJECT_TOSTRING: {
                return proxy.getClass().getName() + "@" + Integer.toHexString(proxy.hashCode());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Object is = m_invokeSwitchTable.get(methodName);
        if (null == is) {
            is = SwitchTable._ABSENT;
        }
        SwitchTable invokeSwitch = is;
        this.m_jdbcPooledConnection.heartbeat();
        if (this.creationTS < this.m_jdbcPooledConnection.getAvailableStartTime() || this.creationTS < this.m_jdbcPooledConnection.getBorrowedStartTime()) {
            this.m_closed = true;
        }
        try {
            is = this.m_closed;
            synchronized (is) {
                boolean closed;
                Object preResult = this.proxyInvokeBeforeTargetInvoke(proxy, methodName, args);
                if (preResult != null) {
                    return preResult;
                }
                if (SwitchTable.CLOSE == invokeSwitch) {
                    if (null != args && 1 == args.length && (args[0] instanceof Integer || args[0] instanceof Properties)) {
                        method.invoke(this.m_proxiedConnection, args[0]);
                        this.m_jdbcPooledConnection.heartbeat();
                    } else {
                        if (this.m_closed.booleanValue()) {
                            return null;
                        }
                        this.m_closed = true;
                        try {
                            this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
                        }
                        catch (UniversalConnectionPoolException ucpe) {
                            Throwable invokeTargetExc = ucpe.getCause();
                            if (invokeTargetExc != null) {
                                Throwable sqlexc = invokeTargetExc.getCause();
                                if (sqlexc != null) {
                                    throw sqlexc;
                                }
                                throw ucpe;
                            }
                            throw ucpe;
                        }
                    }
                    return null;
                }
                UniversalPooledConnectionStatus status = this.m_jdbcPooledConnection.getStatus();
                boolean bl = closed = this.m_closed != false || status == UniversalPooledConnectionStatus.STATUS_CLOSED || status == UniversalPooledConnectionStatus.STATUS_BAD;
                if (closed) {
                    switch (invokeSwitch) {
                        case ISUSABLE: 
                        case ISVALID: {
                            return false;
                        }
                    }
                    throw UCPErrorHandler.newSQLException(31);
                }
                switch (invokeSwitch) {
                    case ISVALID: {
                        if (args == null) {
                            return this.m_jdbcPooledConnection.isValid();
                        }
                        if (args.length == 1 && args[0] instanceof Integer) {
                            return this.m_jdbcPooledConnection.isValid(((Integer)args[0]).intValue());
                        }
                        return method.invoke((Object)this, args);
                    }
                    case _REST: {
                        return method.invoke((Object)this, args);
                    }
                }
                Object result = method.invoke(this.m_proxiedConnection, args);
                this.m_jdbcPooledConnection.heartbeat();
                Object postResult = this.proxyInvokeAfterTargetInvoke(proxy, methodName, result);
                return postResult != result ? postResult : result;
            }
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getCause();
            if (Util.isSQLRecoverableException(t)) {
                this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                this.m_jdbcConnectionPool.returnConnection(this.m_jdbcPooledConnection);
            }
            logger.throwing(this.getClass().getName(), "invoke", t);
            throw t;
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "invoke", e);
            throw e;
        }
    }

    public void applyConnectionLabel(String key, String value) throws SQLException {
        try {
            this.m_jdbcPooledConnection.applyConnectionLabel(key, value);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(32, ucpExc);
        }
        logger.log(Level.FINEST, "key:{0}, value:{1}", new Object[]{key, value});
    }

    public void removeConnectionLabel(String key) throws SQLException {
        try {
            this.m_jdbcPooledConnection.removeConnectionLabel(key);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(33, ucpExc);
        }
        logger.log(Level.FINEST, "key:{0}", key);
    }

    public Properties getConnectionLabels() throws SQLException {
        Properties props = null;
        try {
            props = this.m_jdbcPooledConnection.getConnectionLabels();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(34, ucpExc);
        }
        return props;
    }

    public Properties getUnmatchedConnectionLabels(Properties requestedLabels) throws SQLException {
        Properties props = null;
        try {
            props = this.m_jdbcPooledConnection.getUnmatchedConnectionLabels(requestedLabels);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(35, ucpExc);
        }
        return props;
    }

    public void setConnectionHarvestable(boolean isConnectionHarvestable) throws SQLException {
        try {
            this.m_jdbcPooledConnection.setConnectionHarvestable(isConnectionHarvestable);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(36, ucpExc);
        }
    }

    public boolean isConnectionHarvestable() throws SQLException {
        return this.m_jdbcPooledConnection.isConnectionHarvestable();
    }

    public void registerConnectionHarvestingCallback(ConnectionHarvestingCallback cbk) throws SQLException {
        try {
            this.m_jdbcPooledConnection.registerConnectionHarvestingCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(37, ucpExc);
        }
        logger.log(Level.FINEST, "cbk: {0}", cbk);
    }

    public void removeConnectionHarvestingCallback() throws SQLException {
        try {
            this.m_jdbcPooledConnection.removeConnectionHarvestingCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(38, ucpExc);
        }
        logger.finest("removeConnectionHarvestingCallback");
    }

    public void registerAbandonedConnectionTimeoutCallback(AbandonedConnectionTimeoutCallback cbk) throws SQLException {
        try {
            this.m_jdbcPooledConnection.registerAbandonedConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(39, ucpExc);
        }
        logger.log(Level.FINEST, "cbk: {0}", cbk);
    }

    public void removeAbandonedConnectionTimeoutCallback() throws SQLException {
        try {
            this.m_jdbcPooledConnection.removeAbandonedConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(40, ucpExc);
        }
        logger.finest("removeAbandonedConnectionTimeoutCallback");
    }

    public void registerTimeToLiveConnectionTimeoutCallback(TimeToLiveConnectionTimeoutCallback cbk) throws SQLException {
        try {
            this.m_jdbcPooledConnection.registerTimeToLiveConnectionTimeoutCallback(cbk);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(41, ucpExc);
        }
        logger.log(Level.FINEST, "cbk: {1}", cbk);
    }

    public void removeTimeToLiveConnectionTimeoutCallback() throws SQLException {
        try {
            this.m_jdbcPooledConnection.removeTimeToLiveConnectionTimeoutCallback();
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(42, ucpExc);
        }
        logger.finest("removeTimeToLiveConnectionTimeoutCallback");
    }

    public boolean isValid() throws SQLException {
        return this.m_jdbcPooledConnection.isValid();
    }

    public void setInvalid() throws SQLException {
        try {
            this.m_jdbcPooledConnection.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
        }
        catch (UniversalConnectionPoolException ucpExc) {
            UCPErrorHandler.throwSQLException(47, ucpExc);
        }
        logger.finest("setInvalid() returns");
    }

    protected static Class[] createInterfaces(Object object) {
        Class<?> objectClass = object.getClass();
        Class[] knownInterfaces = m_mapKnownInterfaces.get(objectClass);
        if (null != knownInterfaces) {
            return knownInterfaces;
        }
        HashSet<Class<ValidConnection>> interfacesSet = new HashSet<Class<ValidConnection>>();
        JDBCConnectionProxyFactory.addInterfaces(interfacesSet, objectClass);
        interfacesSet.add(LabelableConnection.class);
        interfacesSet.add(HarvestableConnection.class);
        interfacesSet.add(ConnectionWithAbandonedTimeout.class);
        interfacesSet.add(ConnectionWithTimeToLiveTimeout.class);
        interfacesSet.add(ValidConnection.class);
        Class[] interfaces = interfacesSet.toArray(new Class[0]);
        m_mapKnownInterfaces.put(objectClass, interfaces);
        return interfaces;
    }

    private static void addInterfaces(HashSet interfaces, Class type) {
        if (type == null) {
            return;
        }
        Class<?>[] proxyInterfaces = type.getInterfaces();
        for (int i = 0; i < proxyInterfaces.length; ++i) {
            Class<?> proxyInterface = proxyInterfaces[i];
            interfaces.add(proxyInterface);
        }
        JDBCConnectionProxyFactory.addInterfaces(interfaces, type.getSuperclass());
    }

    static {
        m_invokeSwitchTable.put("close", SwitchTable.CLOSE);
        m_invokeSwitchTable.put("isValid", SwitchTable.ISVALID);
        m_invokeSwitchTable.put("isUsable", SwitchTable.ISUSABLE);
        m_invokeSwitchTable.put("applyConnectionLabel", SwitchTable._REST);
        m_invokeSwitchTable.put("removeConnectionLabel", SwitchTable._REST);
        m_invokeSwitchTable.put("getConnectionLabels", SwitchTable._REST);
        m_invokeSwitchTable.put("getUnmatchedConnectionLabels", SwitchTable._REST);
        m_invokeSwitchTable.put("setConnectionHarvestable", SwitchTable._REST);
        m_invokeSwitchTable.put("isConnectionHarvestable", SwitchTable._REST);
        m_invokeSwitchTable.put("registerConnectionHarvestingCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("removeConnectionHarvestingCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("registerAbandonedConnectionTimeoutCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("removeAbandonedConnectionTimeoutCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("registerTimeToLiveConnectionTimeoutCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("removeTimeToLiveConnectionTimeoutCallback", SwitchTable._REST);
        m_invokeSwitchTable.put("setInvalid", SwitchTable._REST);
        m_invokeSwitchTable.put("equals", SwitchTable.OBJECT_EQUALS);
        m_invokeSwitchTable.put("hashCode", SwitchTable.OBJECT_HASHCODE);
        m_invokeSwitchTable.put("toString", SwitchTable.OBJECT_TOSTRING);
        m_mapKnownInterfaces = new HashMap<Class, Class[]>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SwitchTable {
        CLOSE,
        ISVALID,
        ISUSABLE,
        _REST,
        _ABSENT,
        OBJECT_EQUALS,
        OBJECT_HASHCODE,
        OBJECT_TOSTRING;

    }
}

