/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.ConnectionWithAbandonedTimeout;
import oracle.ucp.jdbc.ConnectionWithTimeToLiveTimeout;
import oracle.ucp.jdbc.HarvestableConnection;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;
import oracle.ucp.jdbc.proxy.JDBCConnectionProxyFactory;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class XAConnectionProxyFactory
extends JDBCConnectionProxyFactory
implements InvocationHandler,
LabelableConnection,
HarvestableConnection,
ConnectionWithAbandonedTimeout,
ConnectionWithTimeToLiveTimeout,
ValidConnection {
    private static final Logger logger = UCPLoggerFactory.createLogger(XAConnectionProxyFactory.class.getCanonicalName());

    public static Object createConnectionProxy(JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        Object proxiedConnection = jdbcPooledConnection.getPhysicalConnection();
        Object connectionProxy = Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), XAConnectionProxyFactory.createInterfaces(proxiedConnection), (InvocationHandler)new XAConnectionProxyFactory(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection));
        logger.log(Level.FINEST, "returns {0}", connectionProxy);
        return connectionProxy;
    }

    protected XAConnectionProxyFactory(Object proxiedConnection, JDBCConnectionPool jdbcConnectionPool, JDBCUniversalPooledConnection jdbcPooledConnection) throws UniversalConnectionPoolException {
        super(proxiedConnection, jdbcConnectionPool, jdbcPooledConnection);
    }

    protected void setProxiedConnection(Object proxiedConnection) throws UniversalConnectionPoolException {
        if (!(proxiedConnection instanceof XAConnection)) {
            UniversalConnectionPoolException ucpe = UCPErrorHandler.newUniversalConnectionPoolException(267);
            logger.throwing(this.getClass().getName(), "setProxiedConnection", ucpe);
            throw ucpe;
        }
        this.m_proxiedConnection = (XAConnection)proxiedConnection;
    }

    protected Object proxyInvokeAfterTargetInvoke(Object proxy, String methodName, Object result) throws Throwable {
        return result;
    }
}

