/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ucp.util.logging.UCPLoggerFactory;

public class UniqueIdentifier {
    private static final Logger logger = UCPLoggerFactory.createLogger(UniqueIdentifier.class.getCanonicalName());
    private static final AtomicInteger m_idNum = new AtomicInteger(0);
    private static final String m_jvmInstanceId = new UniqueIdentifier("").initJvmInstanceId();
    private static final String m_hostname = new UniqueIdentifier("").initHostName();
    private final String m_uniqueID;

    String initHostName() {
        String hostname = null;
        try {
            hostname = this.getLocalHostName();
        }
        catch (UnknownHostException e) {
            logger.finest("failed to get this host's name");
        }
        if ("localhost".equals(hostname)) {
            logger.finest("'localhost' is not a unique hostname");
            hostname = null;
        }
        return hostname;
    }

    String initJvmInstanceId() {
        String jvmInstanceId = null;
        File tempfile = null;
        try {
            tempfile = (File)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() {
                    try {
                        File tmpf = new UniqueIdentifier("").createTempFile("UCP-");
                        tmpf.deleteOnExit();
                        return tmpf;
                    }
                    catch (IOException e) {
                        logger.finest("failed to create temp file");
                        return null;
                    }
                }
            });
            if (tempfile != null) {
                jvmInstanceId = tempfile.getName().split("-")[1];
            }
        }
        catch (PrivilegedActionException e) {
            logger.log(Level.FINEST, "Creating temporary file", e);
        }
        return jvmInstanceId;
    }

    public UniqueIdentifier(String prefix) {
        this.m_uniqueID = null != m_jvmInstanceId && null != m_hostname ? new StringBuilder(256).append(prefix).append(m_jvmInstanceId).append('-').append(m_idNum.incrementAndGet()).append('-').append(m_hostname).toString() : UUID.randomUUID().toString();
    }

    public boolean equals(Object uniqueID) {
        boolean ret_Value = false;
        if (uniqueID != null && uniqueID instanceof UniqueIdentifier && this == uniqueID) {
            ret_Value = true;
        }
        return ret_Value;
    }

    public int hashCode() {
        return this.m_uniqueID.hashCode();
    }

    public String toString() {
        return this.m_uniqueID;
    }

    public static UniqueIdentifier generateUniqueID(String prefix) {
        return new UniqueIdentifier(prefix);
    }

    protected String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    protected File createTempFile(String prefix) throws IOException {
        return File.createTempFile(prefix, "");
    }
}

