/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.lang.reflect.Executable;
import java.util.Comparator;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import oracle.ucp.AbandonedConnectionTimeoutCallback;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.TimeToLiveConnectionTimeoutCallback;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.Clock;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.common.Selector;
import oracle.ucp.common.Selectors;
import oracle.ucp.logging.ClioSupport;
import oracle.ucp.logging.annotations.DefaultLogger;
import oracle.ucp.logging.annotations.Feature;
import oracle.ucp.logging.annotations.Supports;
import oracle.ucp.util.UCPErrorHandler;

@DefaultLogger(value="oracle.ucp.common")
@Supports(value={Feature.CHECK_IN, Feature.CHECK_OUT, Feature.LABELING, Feature.CONN_CONSTRUCTION, Feature.CONN_DESTRUCTION, Feature.CONN_HARVESTING, Feature.TTL_CONN_TIMEOUT, Feature.ABANDONED_CONN_TIMEOUT})
abstract class Database
implements ConnectionSource {
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    Database() {
    }

    protected abstract ConnectionFactoryAdapter getConnectionFactoryAdapter();

    protected abstract AtomicInteger connectionsCreated();

    protected abstract AtomicInteger connectionsClosed();

    @Override
    public Comparator<CoreConnection> costComparator(final Properties labels) {
        return new Comparator<CoreConnection>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;
            private static Executable $$$methodRef$$$3;
            private static Logger $$$loggerRef$$$3;

            @Override
            public int compare(CoreConnection conn1, CoreConnection conn2) {
                if (null == conn1) {
                    throw new IllegalArgumentException("conn1 is null");
                }
                if (null == conn2) {
                    throw new IllegalArgumentException("conn2 is null");
                }
                UniversalPooledConnection upc1 = (UniversalPooledConnection)conn1.getDelegate();
                UniversalPooledConnection upc2 = (UniversalPooledConnection)conn2.getDelegate();
                return upc1.labelingCost(labels) - upc2.labelingCost(labels);
            }

            @Override
            public boolean equals(Object that) {
                if (!(that instanceof Comparator)) {
                    return false;
                }
                return this == that;
            }

            static {
                try {
                    $$$methodRef$$$3 = 1.class.getDeclaredConstructor(Database.class, Properties.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredMethod("compare", Object.class, Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("equals", Object.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("compare", CoreConnection.class, CoreConnection.class);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
            }
        };
    }

    @Override
    public Selector perfectCostSelector(Properties labels) {
        return conn -> 0 == ((UniversalPooledConnection)conn.getDelegate()).labelingCost(labels);
    }

    @Override
    public Selector physicalConnectionSelector(Object physicalConn) {
        return conn -> physicalConn == ((UniversalPooledConnection)conn.getDelegate()).getPhysicalConnection();
    }

    @Override
    public Selector wrongCostSelector(Properties labels) {
        return conn -> Integer.MAX_VALUE == ((UniversalPooledConnection)conn.getDelegate()).labelingCost(labels);
    }

    @Override
    public Selector matchingCriSelector(ConnectionRetrievalInfo cri) {
        return conn -> conn.cri().equalsIncludingPassword(cri);
    }

    @Override
    public Selector availableConnectionsSelector() {
        return conn -> conn.available();
    }

    @Override
    public Selector harvestableConnectionSelector() {
        return conn -> ((UniversalPooledConnection)conn.getDelegate()).isConnectionHarvestable();
    }

    @Override
    public Selector inactiveConnectionsSelector(long inactivityTimeout) {
        Selector inactive = conn -> {
            UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
            return Clock.clock() - inactivityTimeout >= upc.getAvailableStartTime();
        };
        return Selectors.and(this.availableConnectionsSelector(), inactive);
    }

    @Override
    public Selector abandonedConnectionsSelector(long abandonedTimeout) {
        Selector abandoned = conn -> {
            AbandonedConnectionTimeoutCallback cbkOnThisConn;
            long now = Clock.clock();
            UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
            if (upc.getAvailableStartTime() > now || upc.getBorrowedStartTime() > now) {
                return false;
            }
            if (upc.getLastAccessedTime() > now - abandonedTimeout || upc.isSqlWithQueryTimeoutInProgress()) {
                return false;
            }
            try {
                cbkOnThisConn = upc.getAbandonedConnectionTimeoutCallback();
            }
            catch (UniversalConnectionPoolException e) {
                ClioSupport.ilogWarning(null, null, null, null, "unable to get abandoned connection timeout callback");
                return false;
            }
            return cbkOnThisConn == null || cbkOnThisConn != null && !cbkOnThisConn.handleTimedOutConnection();
        };
        return Selectors.and(Selectors.not(this.availableConnectionsSelector()), this.harvestableConnectionSelector(), abandoned);
    }

    @Override
    public Selector ttlConnectionsSelector(long TTLTimeout) {
        Selector abandoned = conn -> {
            TimeToLiveConnectionTimeoutCallback cbkOnThisConn;
            long now = Clock.clock();
            UniversalPooledConnection upc = (UniversalPooledConnection)conn.getDelegate();
            if (upc.getAvailableStartTime() > now || upc.getBorrowedStartTime() > now) {
                return false;
            }
            if (upc.getBorrowedStartTime() > now - TTLTimeout) {
                return false;
            }
            try {
                cbkOnThisConn = upc.getTimeToLiveConnectionTimeoutCallback();
            }
            catch (UniversalConnectionPoolException e) {
                ClioSupport.ilogWarning(null, null, null, null, "unable to get time-to-live connection timeout callback");
                return false;
            }
            return cbkOnThisConn == null || cbkOnThisConn != null && !cbkOnThisConn.handleTimedOutConnection();
        };
        return Selectors.and(Selectors.not(this.availableConnectionsSelector()), this.harvestableConnectionSelector(), abandoned);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UniversalPooledConnection createPooledConnection(ConnectionRetrievalInfo cri) throws UniversalConnectionPoolException {
        if (cri == null) {
            ClioSupport.ilogWarning(null, null, null, null, "CRI is not defined");
            return null;
        }
        Object connection = null;
        UniversalPooledConnection upc = null;
        try {
            connection = this.getConnectionFactoryAdapter().createConnection(cri);
            if (null == connection) {
                UCPErrorHandler.throwUniversalConnectionPoolException(100);
            }
            upc = this.getConnectionFactoryAdapter().createPooledConnection(connection, cri.getCopyWithNoLabels());
            this.connectionsCreated().incrementAndGet();
        }
        finally {
            if (null != connection && null == upc) {
                try {
                    this.getConnectionFactoryAdapter().closeConnection(connection);
                    this.connectionsClosed().incrementAndGet();
                }
                catch (UniversalConnectionPoolException e) {
                    ClioSupport.ilogThrowing(null, null, null, null, e);
                }
            }
        }
        return upc;
    }

    static {
        try {
            $$$methodRef$$$20 = Database.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$19 = Database.class.getDeclaredMethod("lambda$perfectCostSelector$0", Properties.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$18 = Database.class.getDeclaredMethod("lambda$physicalConnectionSelector$1", Object.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$17 = Database.class.getDeclaredMethod("lambda$wrongCostSelector$2", Properties.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$16 = Database.class.getDeclaredMethod("lambda$matchingCriSelector$3", ConnectionRetrievalInfo.class, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$15 = Database.class.getDeclaredMethod("lambda$availableConnectionsSelector$4", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$14 = Database.class.getDeclaredMethod("lambda$harvestableConnectionSelector$5", CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$13 = Database.class.getDeclaredMethod("lambda$inactiveConnectionsSelector$6", Long.TYPE, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$12 = Database.class.getDeclaredMethod("lambda$abandonedConnectionsSelector$7", Long.TYPE, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$11 = Database.class.getDeclaredMethod("lambda$ttlConnectionsSelector$8", Long.TYPE, CoreConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$10 = Database.class.getDeclaredMethod("createPooledConnection", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$9 = Database.class.getDeclaredMethod("ttlConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$8 = Database.class.getDeclaredMethod("abandonedConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$7 = Database.class.getDeclaredMethod("inactiveConnectionsSelector", Long.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$6 = Database.class.getDeclaredMethod("harvestableConnectionSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$5 = Database.class.getDeclaredMethod("availableConnectionsSelector", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$4 = Database.class.getDeclaredMethod("matchingCriSelector", ConnectionRetrievalInfo.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$3 = Database.class.getDeclaredMethod("wrongCostSelector", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$2 = Database.class.getDeclaredMethod("physicalConnectionSelector", Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$1 = Database.class.getDeclaredMethod("perfectCostSelector", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
        try {
            $$$methodRef$$$0 = Database.class.getDeclaredMethod("costComparator", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.ucp");
    }
}

