/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.juncture.nasdaq.itch50;

import com.paritytrading.foundation.ByteBuffers;
import java.nio.ByteBuffer;

public class ITCH50 {
    public static final byte BUY = 66;
    public static final byte SELL = 83;
    public static final byte YES = 89;
    public static final byte NO = 78;
    public static final byte NOT_AVAILABLE = 32;
    public static final byte MESSAGE_TYPE_SYSTEM_EVENT = 83;
    public static final byte MESSAGE_TYPE_STOCK_DIRECTORY = 82;
    public static final byte MESSAGE_TYPE_STOCK_TRADING_ACTION = 72;
    public static final byte MESSAGE_TYPE_REG_SHO_RESTRICTION = 89;
    public static final byte MESSAGE_TYPE_MARKET_PARTICIPANT_POSITION = 76;
    public static final byte MESSAGE_TYPE_MWCB_DECLINE_LEVEL = 86;
    public static final byte MESSAGE_TYPE_MWCB_STATUS = 87;
    public static final byte MESSAGE_TYPE_IPO_QUOTING_PERIOD_UPDATE = 75;
    public static final byte MESSAGE_TYPE_LULD_AUCTION_COLLAR = 74;
    public static final byte MESSAGE_TYPE_OPERATIONAL_HALT = 104;
    public static final byte MESSAGE_TYPE_ADD_ORDER = 65;
    public static final byte MESSAGE_TYPE_ADD_ORDER_MPID = 70;
    public static final byte MESSAGE_TYPE_ORDER_EXECUTED = 69;
    public static final byte MESSAGE_TYPE_ORDER_EXECUTED_WITH_PRICE = 67;
    public static final byte MESSAGE_TYPE_ORDER_CANCEL = 88;
    public static final byte MESSAGE_TYPE_ORDER_DELETE = 68;
    public static final byte MESSAGE_TYPE_ORDER_REPLACE = 85;
    public static final byte MESSAGE_TYPE_TRADE = 80;
    public static final byte MESSAGE_TYPE_CROSS_TRADE = 81;
    public static final byte MESSAGE_TYPE_BROKEN_TRADE = 66;
    public static final byte MESSAGE_TYPE_NOII = 73;
    public static final byte MESSAGE_TYPE_RPII = 78;
    public static final byte EVENT_CODE_START_OF_MESSAGES = 79;
    public static final byte EVENT_CODE_START_OF_SYSTEM_HOURS = 83;
    public static final byte EVENT_CODE_START_OF_MARKET_HOURS = 81;
    public static final byte EVENT_CODE_END_OF_MARKET_HOURS = 77;
    public static final byte EVENT_CODE_END_OF_SYSTEM_HOURS = 69;
    public static final byte EVENT_CODE_END_OF_MESSAGES = 67;
    public static final byte MARKET_CATEGORY_NASDAQ_GLOBAL_SELECT_MARKET = 81;
    public static final byte MARKET_CATEGORY_NASDAQ_GLOBAL_MARKET = 71;
    public static final byte MARKET_CATEGORY_NASDAQ_CAPITAL_MARKET = 83;
    public static final byte MARKET_CATEGORY_NYSE = 78;
    public static final byte MARKET_CATEGORY_NYSE_MKT = 65;
    public static final byte MARKET_CATEGORY_NYSE_ARCA = 80;
    public static final byte MARKET_CATEGORY_BATS_Z_EXCHANGE = 90;
    public static final byte MARKET_CATEGORY_NOT_AVAILABLE = 32;
    public static final byte FINANCIAL_STATUS_INDICATOR_DEFICIENT = 68;
    public static final byte FINANCIAL_STATUS_INDICATOR_DELINQUENT = 69;
    public static final byte FINANCIAL_STATUS_INDICATOR_BANKRUPT = 81;
    public static final byte FINANCIAL_STATUS_INDICATOR_SUSPENDED = 83;
    public static final byte FINANCIAL_STATUS_INDICATOR_DEFICIENT_BANKRUPT = 71;
    public static final byte FINANCIAL_STATUS_INDICATOR_DEFICIENT_DELINQUENT = 72;
    public static final byte FINANCIAL_STATUS_INDICATOR_DELINQUENT_BANKRUPT = 74;
    public static final byte FINANCIAL_STATUS_INDICATOR_DEFICIENT_DELINQUENT_BANKRUPT = 75;
    public static final byte FINANCIAL_STATUS_INDICATOR_CREATIONS_REDEMPTIONS_SUSPENDED = 67;
    public static final byte FINANCIAL_STATUS_INDICATOR_NORMAL = 78;
    public static final byte FINANCIAL_STATUS_INDICATOR_NOT_AVAILABLE = 32;
    public static final byte AUTHENTICITY_PRODUCTION = 80;
    public static final byte AUTHENTICTY_TEST = 84;
    public static final byte LULD_REFERENCE_PRICE_TIER_1 = 49;
    public static final byte LULD_REFERENCE_PRICE_TIER_2 = 50;
    public static final byte TRADING_STATE_HALTED = 72;
    public static final byte TRADING_STATE_PAUSED = 80;
    public static final byte TRADING_STATE_QUOTATION_PERIOD = 81;
    public static final byte TRADING_STATE_TRADING = 84;
    public static final byte REG_SHO_ACTION_NO_PRICE_TEST = 48;
    public static final byte REG_SHO_ACTION_SHORT_SALE_PRICE_TEST_INTRA_DAY_PRICE_DROP = 49;
    public static final byte REG_SHO_ACTION_SHORT_SALE_PRICE_TEST = 50;
    public static final byte MARKET_MAKER_MODE_NORMAL = 78;
    public static final byte MARKET_MAKER_MODE_PASSIVE = 80;
    public static final byte MARKET_MAKER_MODE_SYNDICATE = 83;
    public static final byte MARKET_MAKER_MODE_PRE_SYNDICATE = 82;
    public static final byte MARKET_MAKER_MODE_PENALTY = 76;
    public static final byte MARKET_PARTICIPANT_STATE_ACTIVE = 65;
    public static final byte MARKET_PARTICIPANT_STATE_EXCUSED_WITHDRAWN = 69;
    public static final byte MARKET_PARTICIPANT_STATE_WITHDRAWN = 87;
    public static final byte MARKET_PARTICIPANT_STATE_SUSPENDED = 83;
    public static final byte MARKET_PARTICIPANT_STATE_DELETED = 68;
    public static final byte BREACHED_LEVEL_1 = 49;
    public static final byte BREACHED_LEVEL_2 = 50;
    public static final byte BREACHED_LEVEL_3 = 51;
    public static final byte IPO_QUOTATION_RELEASE_QUALIFIER_ANTICIPATED_QUOTATION_TIME = 65;
    public static final byte IPO_QUOTATION_RELEASE_QUALIFIER_IPO_RELEASE_CANCELED_POSTPONED = 67;
    public static final byte MARKET_CODE_NASDAQ = 81;
    public static final byte MARKET_CODE_BX = 66;
    public static final byte MARKET_CODE_PSX = 88;
    public static final byte OPERATIONAL_HALT_ACTION_OPERATIONALLY_HALTED = 72;
    public static final byte OPERATIONAL_HALT_ACTION_TRADING_RESUMED = 84;
    public static final byte CROSS_TYPE_OPENING_CROSS = 79;
    public static final byte CROSS_TYPE_CLOSING_CROSS = 67;
    public static final byte CROSS_TYPE_IPO_HALTED_PAUSED_CROSS = 72;
    public static final byte CROSS_TYPE_INTRADAY_CROSS = 73;
    public static final byte IMBALANCE_DIRECTION_BUY_IMBALANCE = 66;
    public static final byte IMBALANCE_DIRECTION_SELL_IMBALANCE = 83;
    public static final byte IMBALANCE_DIRECTION_NO_IMBALANCE = 78;
    public static final byte IMBALANCE_DIRECTION_INSUFFICIENT_ORDERS = 79;
    public static final byte PRICE_VARIATION_INDICATOR_LESS_THAN_1_PCT = 76;
    public static final byte PRICE_VARIATION_INDICATOR_1_TO_1_99_PCT = 49;
    public static final byte PRICE_VARIATION_INDICATOR_2_TO_2_99_PCT = 50;
    public static final byte PRICE_VARIATION_INDICATOR_3_TO_3_99_PCT = 51;
    public static final byte PRICE_VARIATION_INDICATOR_4_TO_4_99_PCT = 52;
    public static final byte PRICE_VARIATION_INDICATOR_5_TO_5_99_PCT = 53;
    public static final byte PRICE_VARIATION_INDICATOR_6_TO_6_99_PCT = 54;
    public static final byte PRICE_VARIATION_INDICATOR_7_TO_7_99_PCT = 55;
    public static final byte PRICE_VARIATION_INDICATOR_8_TO_8_99_PCT = 56;
    public static final byte PRICE_VARIATION_INDICATOR_9_TO_9_99_PCT = 57;
    public static final byte PRICE_VARIATION_INDICATOR_10_TO_19_99_PCT = 65;
    public static final byte PRICE_VARIATION_INDICATOR_20_TO_29_99_PCT = 66;
    public static final byte PRICE_VARIATION_INDICATOR_30_PCT_OR_GREATER = 67;
    public static final byte PRICE_VARIATION_INDICATOR_NOT_AVAILABLE = 32;
    public static final byte INTEREST_FLAG_BUY = 66;
    public static final byte INTEREST_FLAG_SELL = 83;
    public static final byte INTEREST_FLAG_BOTH = 65;
    public static final byte INTEREST_FLAG_NONE = 78;

    private ITCH50() {
    }

    public static class RPII
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long stock;
        public byte interestFlag;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.interestFlag = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)78);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.stock);
            buffer.put(this.interestFlag);
        }
    }

    public static class NOII
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long pairedShares;
        public long imbalanceShares;
        public byte imbalanceDirection;
        public long stock;
        public long farPrice;
        public long nearPrice;
        public long currentReferencePrice;
        public byte crossType;
        public byte priceVariationIndicator;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.pairedShares = buffer.getLong();
            this.imbalanceShares = buffer.getLong();
            this.imbalanceDirection = buffer.get();
            this.stock = buffer.getLong();
            this.farPrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.nearPrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.currentReferencePrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.crossType = buffer.get();
            this.priceVariationIndicator = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)73);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.pairedShares);
            buffer.putLong(this.imbalanceShares);
            buffer.put(this.imbalanceDirection);
            buffer.putLong(this.stock);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.farPrice);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.nearPrice);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.currentReferencePrice);
            buffer.put(this.crossType);
            buffer.put(this.priceVariationIndicator);
        }
    }

    public static class BrokenTrade
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long matchNumber;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.matchNumber = buffer.getLong();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)66);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.matchNumber);
        }
    }

    public static class CrossTrade
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long shares;
        public long stock;
        public long crossPrice;
        public long matchNumber;
        public byte crossType;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.shares = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.crossPrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.matchNumber = buffer.getLong();
            this.crossType = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)81);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.shares);
            buffer.putLong(this.stock);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.crossPrice);
            buffer.putLong(this.matchNumber);
            buffer.put(this.crossType);
        }
    }

    public static class Trade
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long orderReferenceNumber;
        public byte buySellIndicator;
        public long shares;
        public long stock;
        public long price;
        public long matchNumber;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.orderReferenceNumber = buffer.getLong();
            this.buySellIndicator = buffer.get();
            this.shares = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.price = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.matchNumber = buffer.getLong();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)80);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.orderReferenceNumber);
            buffer.put(this.buySellIndicator);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.shares);
            buffer.putLong(this.stock);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.price);
            buffer.putLong(this.matchNumber);
        }
    }

    public static class OrderReplace
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long originalOrderReferenceNumber;
        public long newOrderReferenceNumber;
        public long shares;
        public long price;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.originalOrderReferenceNumber = buffer.getLong();
            this.newOrderReferenceNumber = buffer.getLong();
            this.shares = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.price = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)85);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.originalOrderReferenceNumber);
            buffer.putLong(this.newOrderReferenceNumber);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.shares);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.price);
        }
    }

    public static class OrderDelete
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long orderReferenceNumber;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.orderReferenceNumber = buffer.getLong();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)68);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.orderReferenceNumber);
        }
    }

    public static class OrderCancel
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long orderReferenceNumber;
        public long canceledShares;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.orderReferenceNumber = buffer.getLong();
            this.canceledShares = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)88);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.orderReferenceNumber);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.canceledShares);
        }
    }

    public static class OrderExecutedWithPrice
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long orderReferenceNumber;
        public long executedShares;
        public long matchNumber;
        public byte printable;
        public long executionPrice;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.orderReferenceNumber = buffer.getLong();
            this.executedShares = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.matchNumber = buffer.getLong();
            this.printable = buffer.get();
            this.executionPrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)67);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.orderReferenceNumber);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.executedShares);
            buffer.putLong(this.matchNumber);
            buffer.put(this.printable);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.executionPrice);
        }
    }

    public static class OrderExecuted
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long orderReferenceNumber;
        public long executedShares;
        public long matchNumber;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.orderReferenceNumber = buffer.getLong();
            this.executedShares = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.matchNumber = buffer.getLong();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)69);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.orderReferenceNumber);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.executedShares);
            buffer.putLong(this.matchNumber);
        }
    }

    public static class AddOrderMPID
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long orderReferenceNumber;
        public byte buySellIndicator;
        public long shares;
        public long stock;
        public long price;
        public int attribution;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.orderReferenceNumber = buffer.getLong();
            this.buySellIndicator = buffer.get();
            this.shares = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.price = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.attribution = buffer.getInt();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)70);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.orderReferenceNumber);
            buffer.put(this.buySellIndicator);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.shares);
            buffer.putLong(this.stock);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.price);
            buffer.putInt(this.attribution);
        }
    }

    public static class AddOrder
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long orderReferenceNumber;
        public byte buySellIndicator;
        public long shares;
        public long stock;
        public long price;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.orderReferenceNumber = buffer.getLong();
            this.buySellIndicator = buffer.get();
            this.shares = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.price = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)65);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.orderReferenceNumber);
            buffer.put(this.buySellIndicator);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.shares);
            buffer.putLong(this.stock);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.price);
        }
    }

    public static class OperationalHalt
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long stock;
        public byte marketCode;
        public byte operationalHaltAction;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.marketCode = buffer.get();
            this.operationalHaltAction = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)104);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.stock);
            buffer.put(this.marketCode);
            buffer.put(this.operationalHaltAction);
        }
    }

    public static class LULDAuctionCollar
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long stock;
        public long auctionCollarReferencePrice;
        public long upperAuctionCollarPrice;
        public long lowerAuctionCollarPrice;
        public long auctionCollarExtension;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.auctionCollarReferencePrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.upperAuctionCollarPrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.lowerAuctionCollarPrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.auctionCollarExtension = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)74);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.stock);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.auctionCollarReferencePrice);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.upperAuctionCollarPrice);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.lowerAuctionCollarPrice);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.auctionCollarExtension);
        }
    }

    public static class IPOQuotingPeriodUpdate
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long stock;
        public long ipoQuotationReleaseTime;
        public byte ipoQuotationReleaseQualifier;
        public long ipoPrice;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.ipoQuotationReleaseTime = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.ipoQuotationReleaseQualifier = buffer.get();
            this.ipoPrice = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)75);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.stock);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.ipoQuotationReleaseTime);
            buffer.put(this.ipoQuotationReleaseQualifier);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.ipoPrice);
        }
    }

    public static class MWCBStatus
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public byte breachedLevel;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.breachedLevel = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)87);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.put(this.breachedLevel);
        }
    }

    public static class MWCBDeclineLevel
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long level1;
        public long level2;
        public long level3;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.level1 = buffer.getLong();
            this.level2 = buffer.getLong();
            this.level3 = buffer.getLong();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)86);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.level1);
            buffer.putLong(this.level2);
            buffer.putLong(this.level3);
        }
    }

    public static class MarketParticipantPosition
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public int mpid;
        public long stock;
        public byte primaryMarketMaker;
        public byte marketMakerMode;
        public byte marketParticipantState;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.mpid = buffer.getInt();
            this.stock = buffer.getLong();
            this.primaryMarketMaker = buffer.get();
            this.marketMakerMode = buffer.get();
            this.marketParticipantState = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)76);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putInt(this.mpid);
            buffer.putLong(this.stock);
            buffer.put(this.primaryMarketMaker);
            buffer.put(this.marketMakerMode);
            buffer.put(this.marketParticipantState);
        }
    }

    public static class RegSHORestriction
    implements Message {
        public int locateCode;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long stock;
        public byte regSHOAction;

        @Override
        public void get(ByteBuffer buffer) {
            this.locateCode = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.regSHOAction = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)89);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.locateCode);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.stock);
            buffer.put(this.regSHOAction);
        }
    }

    public static class StockTradingAction
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long stock;
        public byte tradingState;
        public byte reserved;
        public int reason;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.tradingState = buffer.get();
            this.reserved = buffer.get();
            this.reason = buffer.getInt();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)72);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.stock);
            buffer.put(this.tradingState);
            buffer.put(this.reserved);
            buffer.putInt(this.reason);
        }
    }

    public static class StockDirectory
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public long stock;
        public byte marketCategory;
        public byte financialStatusIndicator;
        public long roundLotSize;
        public byte roundLotsOnly;
        public byte issueClassification;
        public short issueSubType;
        public byte authenticity;
        public byte shortSaleThresholdIndicator;
        public byte ipoFlag;
        public byte luldReferencePriceTier;
        public byte etpFlag;
        public long etpLeverageFactor;
        public byte inverseIndicator;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.stock = buffer.getLong();
            this.marketCategory = buffer.get();
            this.financialStatusIndicator = buffer.get();
            this.roundLotSize = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.roundLotsOnly = buffer.get();
            this.issueClassification = buffer.get();
            this.issueSubType = buffer.getShort();
            this.authenticity = buffer.get();
            this.shortSaleThresholdIndicator = buffer.get();
            this.ipoFlag = buffer.get();
            this.luldReferencePriceTier = buffer.get();
            this.etpFlag = buffer.get();
            this.etpLeverageFactor = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.inverseIndicator = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)82);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.putLong(this.stock);
            buffer.put(this.marketCategory);
            buffer.put(this.financialStatusIndicator);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.roundLotSize);
            buffer.put(this.roundLotsOnly);
            buffer.put(this.issueClassification);
            buffer.putShort(this.issueSubType);
            buffer.put(this.authenticity);
            buffer.put(this.shortSaleThresholdIndicator);
            buffer.put(this.ipoFlag);
            buffer.put(this.luldReferencePriceTier);
            buffer.put(this.etpFlag);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.etpLeverageFactor);
            buffer.put(this.inverseIndicator);
        }
    }

    public static class SystemEvent
    implements Message {
        public int stockLocate;
        public int trackingNumber;
        public int timestampHigh;
        public long timestampLow;
        public byte eventCode;

        @Override
        public void get(ByteBuffer buffer) {
            this.stockLocate = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.trackingNumber = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampHigh = ByteBuffers.getUnsignedShort((ByteBuffer)buffer);
            this.timestampLow = ByteBuffers.getUnsignedInt((ByteBuffer)buffer);
            this.eventCode = buffer.get();
        }

        @Override
        public void put(ByteBuffer buffer) {
            buffer.put((byte)83);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.stockLocate);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.trackingNumber);
            ByteBuffers.putUnsignedShort((ByteBuffer)buffer, (int)this.timestampHigh);
            ByteBuffers.putUnsignedInt((ByteBuffer)buffer, (long)this.timestampLow);
            buffer.put(this.eventCode);
        }
    }

    public static interface Message {
        public void get(ByteBuffer var1);

        public void put(ByteBuffer var1);
    }
}

