/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.util;

import com.paritytrading.nassau.MessageListener;
import com.paritytrading.nassau.soupbintcp.SoupBinTCP;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPClient;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPClientStatusListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;

public class SoupBinTCP {
    private static final int TIMEOUT_MILLIS = 1000;

    private SoupBinTCP() {
    }

    public static void receive(InetSocketAddress address, String username, String password, MessageListener listener) throws IOException {
        SocketChannel channel = SocketChannel.open();
        channel.connect(address);
        channel.configureBlocking(false);
        StatusListener statusListener = new StatusListener();
        try (Selector selector = Selector.open();
             SoupBinTCPClient client = new SoupBinTCPClient(channel, listener, (SoupBinTCPClientStatusListener)statusListener);){
            channel.register(selector, 1);
            SoupBinTCP.LoginRequest message = new SoupBinTCP.LoginRequest();
            message.setUsername(username);
            message.setPassword(password);
            message.setRequestedSession("");
            message.setRequestedSequenceNumber(1L);
            client.login(message);
            while (statusListener.receive) {
                int numKeys = selector.select(1000L);
                if (numKeys > 0) {
                    if (client.receive() < 0) {
                        break;
                    }
                    selector.selectedKeys().clear();
                }
                client.keepAlive();
            }
        }
    }

    private static class StatusListener
    implements SoupBinTCPClientStatusListener {
        boolean receive = true;

        private StatusListener() {
        }

        public void heartbeatTimeout(SoupBinTCPClient session) throws IOException {
            throw new IOException("Heartbeat timeout");
        }

        public void loginAccepted(SoupBinTCPClient session, SoupBinTCP.LoginAccepted payload) {
        }

        public void loginRejected(SoupBinTCPClient session, SoupBinTCP.LoginRejected payload) throws IOException {
            throw new IOException("Login rejected");
        }

        public void endOfSession(SoupBinTCPClient session) {
            this.receive = false;
        }
    }
}

