/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel;

import com.alibaba.excel.converters.Converter;
import com.pig4cloud.plugin.excel.aop.ResponseExcelReturnValueHandler;
import com.pig4cloud.plugin.excel.config.ExcelConfigProperties;
import com.pig4cloud.plugin.excel.enhance.DefaultWriterBuilderEnhancer;
import com.pig4cloud.plugin.excel.enhance.WriterBuilderEnhancer;
import com.pig4cloud.plugin.excel.handler.ManySheetWriteHandler;
import com.pig4cloud.plugin.excel.handler.SheetWriteHandler;
import com.pig4cloud.plugin.excel.handler.SingleSheetWriteHandler;
import com.pig4cloud.plugin.excel.head.I18nHeaderCellWriteHandler;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;

public class ExcelHandlerConfiguration {
    private final ExcelConfigProperties configProperties;
    private final ObjectProvider<List<Converter<?>>> converterProvider;

    @Bean
    @ConditionalOnMissingBean
    public WriterBuilderEnhancer writerBuilderEnhancer() {
        return new DefaultWriterBuilderEnhancer();
    }

    @Bean
    @ConditionalOnMissingBean
    public SingleSheetWriteHandler singleSheetWriteHandler() {
        return new SingleSheetWriteHandler(this.configProperties, this.converterProvider, this.writerBuilderEnhancer());
    }

    @Bean
    @ConditionalOnMissingBean
    public ManySheetWriteHandler manySheetWriteHandler() {
        return new ManySheetWriteHandler(this.configProperties, this.converterProvider, this.writerBuilderEnhancer());
    }

    @Bean
    @ConditionalOnMissingBean
    public ResponseExcelReturnValueHandler responseExcelReturnValueHandler(List<SheetWriteHandler> sheetWriteHandlerList) {
        return new ResponseExcelReturnValueHandler(sheetWriteHandlerList);
    }

    @Bean
    @ConditionalOnBean(value={MessageSource.class})
    @ConditionalOnMissingBean
    public I18nHeaderCellWriteHandler i18nHeaderCellWriteHandler(MessageSource messageSource) {
        return new I18nHeaderCellWriteHandler(messageSource);
    }

    @Generated
    public ExcelHandlerConfiguration(ExcelConfigProperties configProperties, ObjectProvider<List<Converter<?>>> converterProvider) {
        this.configProperties = configProperties;
        this.converterProvider = converterProvider;
    }
}

