/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel.head;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.util.PropertyPlaceholderHelper;

public class I18nHeaderCellWriteHandler
implements CellWriteHandler {
    private final MessageSource messageSource;
    private final PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver;
    private final PropertyPlaceholderHelper propertyPlaceholderHelper = new PropertyPlaceholderHelper("{", "}");

    public I18nHeaderCellWriteHandler(MessageSource messageSource) {
        this.messageSource = messageSource;
        this.placeholderResolver = placeholderName -> this.messageSource.getMessage(placeholderName, null, LocaleContextHolder.getLocale());
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
        List originHeadNameList;
        if (isHead != null && isHead.booleanValue() && CollectionUtils.isNotEmpty((Collection)(originHeadNameList = head.getHeadNameList()))) {
            List i18nHeadNames = originHeadNameList.stream().map(headName -> this.propertyPlaceholderHelper.replacePlaceholders(headName, this.placeholderResolver)).collect(Collectors.toList());
            head.setHeadNameList(i18nHeadNames);
        }
    }

    @Generated
    public I18nHeaderCellWriteHandler(MessageSource messageSource, PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
        this.messageSource = messageSource;
        this.placeholderResolver = placeholderResolver;
    }
}

