/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.raft;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.common.http.Callback;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.notify.listener.Subscriber;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.cluster.Member;
import com.alibaba.nacos.core.cluster.MemberChangeListener;
import com.alibaba.nacos.core.cluster.MembersChangeEvent;
import com.alibaba.nacos.core.cluster.ServerMemberManager;
import com.alibaba.nacos.naming.consistency.persistent.raft.LeaderElectFinishedEvent;
import com.alibaba.nacos.naming.consistency.persistent.raft.MakeLeaderEvent;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftCore;
import com.alibaba.nacos.naming.consistency.persistent.raft.RaftPeer;
import com.alibaba.nacos.naming.misc.HttpClient;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.naming.misc.NetUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.bag.TreeBag;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Deprecated
@Component
@DependsOn(value={"ProtocolManager"})
public class RaftPeerSet
extends MemberChangeListener
implements Closeable {
    private final ServerMemberManager memberManager;
    private AtomicLong localTerm = new AtomicLong(0L);
    private RaftPeer leader = null;
    private volatile Map<String, RaftPeer> peers = new HashMap<String, RaftPeer>(8);
    private Set<String> sites = new HashSet<String>();
    private volatile boolean ready = false;
    private Set<Member> oldMembers = new HashSet<Member>();

    public RaftPeerSet(ServerMemberManager memberManager) {
        this.memberManager = memberManager;
    }

    @PostConstruct
    public void init() {
        NotifyCenter.registerSubscriber((Subscriber)this);
        this.changePeers(this.memberManager.allMembers());
    }

    public void shutdown() throws NacosException {
        this.localTerm.set(-1L);
        this.leader = null;
        this.peers.clear();
        this.sites.clear();
        this.ready = false;
        this.oldMembers.clear();
    }

    public RaftPeer getLeader() {
        if (EnvUtil.getStandaloneMode()) {
            return this.local();
        }
        return this.leader;
    }

    public Set<String> allSites() {
        return this.sites;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void remove(List<String> servers) {
        for (String server : servers) {
            this.peers.remove(server);
        }
    }

    public RaftPeer update(RaftPeer peer) {
        this.peers.put(peer.ip, peer);
        return peer;
    }

    public boolean isLeader(String ip) {
        if (EnvUtil.getStandaloneMode()) {
            return true;
        }
        if (this.leader == null) {
            Loggers.RAFT.warn("[IS LEADER] no leader is available now!");
            return false;
        }
        return StringUtils.equals((String)this.leader.ip, (String)ip);
    }

    public Set<String> allServersIncludeMyself() {
        return this.peers.keySet();
    }

    public Set<String> allServersWithoutMySelf() {
        HashSet<String> servers = new HashSet<String>(this.peers.keySet());
        servers.remove(this.local().ip);
        return servers;
    }

    public Collection<RaftPeer> allPeers() {
        return this.peers.values();
    }

    public int size() {
        return this.peers.size();
    }

    public RaftPeer decideLeader(RaftPeer candidate) {
        this.peers.put(candidate.ip, candidate);
        TreeBag ips = new TreeBag();
        int maxApproveCount = 0;
        String maxApprovePeer = null;
        for (RaftPeer peer : this.peers.values()) {
            if (StringUtils.isEmpty((String)peer.voteFor)) continue;
            ips.add((Object)peer.voteFor);
            if (ips.getCount((Object)peer.voteFor) <= maxApproveCount) continue;
            maxApproveCount = ips.getCount((Object)peer.voteFor);
            maxApprovePeer = peer.voteFor;
        }
        if (maxApproveCount >= this.majorityCount()) {
            RaftPeer peer = this.peers.get(maxApprovePeer);
            peer.state = RaftPeer.State.LEADER;
            if (!Objects.equals(this.leader, peer)) {
                this.leader = peer;
                ApplicationUtils.publishEvent((Object)((Object)new LeaderElectFinishedEvent((Object)this, this.leader, this.local())));
                Loggers.RAFT.info("{} has become the LEADER", (Object)this.leader.ip);
            }
        }
        return this.leader;
    }

    public RaftPeer makeLeader(RaftPeer candidate) {
        if (!Objects.equals(this.leader, candidate)) {
            this.leader = candidate;
            ApplicationUtils.publishEvent((Object)((Object)new MakeLeaderEvent((Object)this, this.leader, this.local())));
            Loggers.RAFT.info("{} has become the LEADER, local: {}, leader: {}", new Object[]{this.leader.ip, JacksonUtils.toJson((Object)this.local()), JacksonUtils.toJson((Object)this.leader)});
        }
        for (final RaftPeer peer : this.peers.values()) {
            HashMap<String, String> params = new HashMap<String, String>(1);
            if (Objects.equals(peer, candidate) || peer.state != RaftPeer.State.LEADER) continue;
            try {
                String url = RaftCore.buildUrl(peer.ip, "/v1/ns/raft/peer");
                HttpClient.asyncHttpGet(url, null, params, new Callback<String>(){

                    public void onReceive(RestResult<String> result) {
                        if (!result.ok()) {
                            Loggers.RAFT.error("[NACOS-RAFT] get peer failed: {}, peer: {}", (Object)result.getCode(), (Object)peer.ip);
                            peer.state = RaftPeer.State.FOLLOWER;
                            return;
                        }
                        RaftPeerSet.this.update((RaftPeer)JacksonUtils.toObj((String)((String)result.getData()), RaftPeer.class));
                    }

                    public void onError(Throwable throwable) {
                    }

                    public void onCancel() {
                    }
                });
            }
            catch (Exception e) {
                peer.state = RaftPeer.State.FOLLOWER;
                Loggers.RAFT.error("[NACOS-RAFT] error while getting peer from peer: {}", (Object)peer.ip);
            }
        }
        return this.update(candidate);
    }

    public RaftPeer local() {
        RaftPeer peer = this.peers.get(EnvUtil.getLocalAddress());
        if (peer == null && EnvUtil.getStandaloneMode()) {
            RaftPeer localPeer = new RaftPeer();
            localPeer.ip = NetUtils.localServer();
            localPeer.term.set(this.localTerm.get());
            this.peers.put(localPeer.ip, localPeer);
            return localPeer;
        }
        if (peer == null) {
            throw new IllegalStateException("unable to find local peer: " + NetUtils.localServer() + ", all peers: " + Arrays.toString(this.peers.keySet().toArray()));
        }
        return peer;
    }

    public RaftPeer get(String server) {
        return this.peers.get(server);
    }

    public int majorityCount() {
        return this.peers.size() / 2 + 1;
    }

    public void reset() {
        this.leader = null;
        for (RaftPeer peer : this.peers.values()) {
            peer.voteFor = null;
        }
    }

    public void setTerm(long term) {
        this.localTerm.set(term);
    }

    public long getTerm() {
        return this.localTerm.get();
    }

    public boolean contains(RaftPeer remote) {
        return this.peers.containsKey(remote.ip);
    }

    public void onEvent(MembersChangeEvent event) {
        Collection members = event.getMembers();
        HashSet newMembers = new HashSet(members);
        newMembers.removeAll(this.oldMembers);
        if (!newMembers.isEmpty()) {
            this.changePeers(members);
        }
        this.oldMembers.clear();
        this.oldMembers.addAll(members);
    }

    protected void changePeers(Collection<Member> members) {
        HashMap<String, RaftPeer> tmpPeers = new HashMap<String, RaftPeer>(members.size());
        for (Member member : members) {
            String address = member.getAddress();
            if (this.peers.containsKey(address)) {
                tmpPeers.put(address, this.peers.get(address));
                continue;
            }
            RaftPeer raftPeer = new RaftPeer();
            raftPeer.ip = address;
            if (EnvUtil.getLocalAddress().equals(address)) {
                raftPeer.term.set(this.localTerm.get());
            }
            tmpPeers.put(address, raftPeer);
        }
        this.peers = tmpPeers;
        this.ready = true;
        Loggers.RAFT.info("raft peers changed: " + members);
    }

    public String toString() {
        return "RaftPeerSet{localTerm=" + this.localTerm + ", leader=" + this.leader + ", peers=" + this.peers + ", sites=" + this.sites + '}';
    }
}

