/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.execute;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.core.InstanceOperatorClientImpl;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteContent;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.DoubleWriteDelayTaskEngine;
import com.alibaba.nacos.naming.core.v2.upgrade.doublewrite.delay.ServiceChangeV1Task;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;

public class DoubleWriteInstanceChangeToV2Task
extends AbstractExecuteTask {
    private final String namespace;
    private final String serviceName;
    private final Instance instance;
    private final boolean register;

    public DoubleWriteInstanceChangeToV2Task(String namespace, String serviceName, Instance instance, boolean register) {
        this.register = register;
        this.namespace = namespace;
        this.serviceName = serviceName;
        this.instance = instance;
    }

    public void run() {
        try {
            InstanceOperatorClientImpl instanceOperator = (InstanceOperatorClientImpl)ApplicationUtils.getBean(InstanceOperatorClientImpl.class);
            if (this.register) {
                instanceOperator.registerInstance(this.namespace, this.serviceName, this.instance);
            } else {
                instanceOperator.removeInstance(this.namespace, this.serviceName, this.instance);
            }
        }
        catch (Exception e) {
            if (Loggers.SRV_LOG.isDebugEnabled()) {
                Loggers.SRV_LOG.debug("Double write task for {}#{} instance from 1 to 2 failed", new Object[]{this.namespace, this.serviceName, e});
            }
            ServiceChangeV1Task retryTask = new ServiceChangeV1Task(this.namespace, this.serviceName, this.instance.isEphemeral(), DoubleWriteContent.INSTANCE);
            retryTask.setTaskInterval(3000L);
            String taskKey = ServiceChangeV1Task.getKey(this.namespace, this.serviceName, this.instance.isEphemeral());
            ((DoubleWriteDelayTaskEngine)((Object)ApplicationUtils.getBean(DoubleWriteDelayTaskEngine.class))).addTask(taskKey, retryTask);
        }
    }
}

