/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.push.v2.hook;

import com.alibaba.nacos.naming.monitor.MetricsMonitor;
import com.alibaba.nacos.naming.monitor.NamingTpsMonitor;
import com.alibaba.nacos.naming.pojo.Subscriber;
import com.alibaba.nacos.naming.push.v2.hook.PushResult;
import com.alibaba.nacos.naming.push.v2.hook.PushResultHook;

public class NacosMonitorPushResultHook
implements PushResultHook {
    @Override
    public void pushSuccess(PushResult result) {
        MetricsMonitor.incrementPush();
        MetricsMonitor.incrementPushCost(result.getAllCost());
        MetricsMonitor.compareAndSetMaxPushCost(result.getAllCost());
        if (this.isRpc(result.getSubscriber())) {
            NamingTpsMonitor.rpcPushSuccess(result.getSubscribeClientId(), result.getSubscriber().getIp());
        } else {
            NamingTpsMonitor.udpPushSuccess(result.getSubscribeClientId(), result.getSubscriber().getIp());
        }
    }

    @Override
    public void pushFailed(PushResult result) {
        MetricsMonitor.incrementFailPush();
        if (this.isRpc(result.getSubscriber())) {
            NamingTpsMonitor.rpcPushFail(result.getSubscribeClientId(), result.getSubscriber().getIp());
        } else {
            NamingTpsMonitor.udpPushFail(result.getSubscribeClientId(), result.getSubscriber().getIp());
        }
    }

    private boolean isRpc(Subscriber subscriber) {
        return subscriber.getPort() <= 0;
    }
}

