/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.utils;

import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.utils.NamingUtils;
import com.alibaba.nacos.naming.core.v2.metadata.InstanceMetadata;
import com.alibaba.nacos.naming.core.v2.pojo.InstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import java.util.HashMap;
import java.util.Map;

public class InstanceUtil {
    public static Instance parseToApiInstance(Service service, InstancePublishInfo instanceInfo) {
        Instance result = new Instance();
        result.setIp(instanceInfo.getIp());
        result.setPort(instanceInfo.getPort());
        result.setServiceName(NamingUtils.getGroupedName((String)service.getName(), (String)service.getGroup()));
        result.setClusterName(instanceInfo.getCluster());
        HashMap<String, String> instanceMetadata = new HashMap<String, String>(instanceInfo.getExtendDatum().size());
        for (Map.Entry<String, Object> entry : instanceInfo.getExtendDatum().entrySet()) {
            if ("customInstanceId".equals(entry.getKey())) {
                result.setInstanceId(entry.getValue().toString());
                continue;
            }
            if ("publishInstanceEnable".equals(entry.getKey())) {
                result.setEnabled(((Boolean)entry.getValue()).booleanValue());
                continue;
            }
            if ("publishInstanceWeight".equals(entry.getKey())) {
                result.setWeight(((Double)entry.getValue()).doubleValue());
                continue;
            }
            instanceMetadata.put(entry.getKey(), null != entry.getValue() ? entry.getValue().toString() : null);
        }
        result.setMetadata(instanceMetadata);
        result.setEphemeral(service.isEphemeral());
        result.setHealthy(instanceInfo.isHealthy());
        return result;
    }

    public static void updateInstanceMetadata(Instance instance, InstanceMetadata metadata) {
        instance.setEnabled(metadata.isEnabled());
        instance.setWeight(metadata.getWeight());
        for (Map.Entry<String, Object> entry : metadata.getExtendData().entrySet()) {
            instance.getMetadata().put(entry.getKey(), entry.getValue().toString());
        }
    }

    public static Instance deepCopy(Instance source) {
        Instance target = new Instance();
        target.setInstanceId(source.getInstanceId());
        target.setIp(source.getIp());
        target.setPort(source.getPort());
        target.setWeight(source.getWeight());
        target.setHealthy(source.isHealthy());
        target.setEnabled(source.isEnabled());
        target.setEphemeral(source.isEphemeral());
        target.setClusterName(source.getClusterName());
        target.setServiceName(source.getServiceName());
        target.setMetadata(new HashMap(source.getMetadata()));
        return target;
    }
}

