/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.core.util;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;

public class IpGetter {
    public static final String CURRENT_IP = IpGetter.findFirstNonLoopbackAddress();
    private static final String NETWORK_CARD = "eth0";
    private static final String NETWORK_CARD_BAND = "bond0";

    public static String getLocalHostName() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getLocalIP() {
        String ip = "";
        try {
            Enumeration<NetworkInterface> e1 = NetworkInterface.getNetworkInterfaces();
            while (e1.hasMoreElements()) {
                NetworkInterface ni = e1.nextElement();
                if (!NETWORK_CARD.equals(ni.getName()) && !NETWORK_CARD_BAND.equals(ni.getName())) continue;
                Enumeration<InetAddress> e2 = ni.getInetAddresses();
                while (e2.hasMoreElements()) {
                    InetAddress ia = e2.nextElement();
                    if (ia instanceof Inet6Address) continue;
                    ip = ia.getHostAddress();
                }
                break;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return ip;
    }

    public static Collection<InetAddress> getAllHostAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    addresses.add(inetAddress);
                }
            }
            return addresses;
        }
        catch (SocketException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String getIp() {
        String localHostAddress = "127.0.0.1";
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> address = networkInterface.getInetAddresses();
                while (address.hasMoreElements()) {
                    InetAddress inetAddress = address.nextElement();
                    if (inetAddress == null || !(inetAddress instanceof Inet4Address) || "127.0.0.1".equals(inetAddress.getHostAddress())) continue;
                    localHostAddress = inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localHostAddress;
    }

    public static String findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    result = address;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result != null) {
            return result.getHostAddress();
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "127.0.0.1";
        }
    }
}

