/*
 * Decompiled with CFR 0.152.
 */
package com.plumelog.log4j2.appender;

import com.plumelog.core.MessageAppenderFactory;
import com.plumelog.core.client.AbstractClient;
import com.plumelog.core.constant.LogMessageConstant;
import com.plumelog.core.dto.BaseLogMessage;
import com.plumelog.core.dto.RunLogMessage;
import com.plumelog.core.kafka.KafkaProducerClient;
import com.plumelog.core.util.GfJsonUtil;
import com.plumelog.core.util.ThreadPoolUtil;
import com.plumelog.log4j2.util.LogMessageUtil;
import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="KafkaAppender", category="Core", elementType="appender", printObject=true)
public class KafkaAppender
extends AbstractAppender {
    private static KafkaProducerClient kafkaClient;
    private static final ThreadPoolExecutor threadPoolExecutor;
    private final String appName;
    private final String env;
    private final String kafkaHosts;
    private final String runModel;
    private final String expand;
    private int maxCount = 500;
    private int logQueueSize = 10000;
    private int threadPoolSize = 1;

    protected KafkaAppender(String name, String appName, String env, String kafkaHosts, String runModel, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, String expand, int maxCount, int logQueueSize, int threadPoolSize) {
        super(name, filter, layout, ignoreExceptions);
        this.appName = appName;
        this.env = env;
        this.kafkaHosts = kafkaHosts;
        this.runModel = runModel;
        this.expand = expand;
        this.maxCount = maxCount;
        this.logQueueSize = logQueueSize;
        this.threadPoolSize = threadPoolSize;
    }

    @PluginFactory
    public static KafkaAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="appName") String appName, @PluginAttribute(value="env") String env, @PluginAttribute(value="kafkaHosts") String kafkaHosts, @PluginAttribute(value="topic") String topic, @PluginAttribute(value="expand") String expand, @PluginAttribute(value="runModel") String runModel, @PluginAttribute(value="maxCount") int maxCount, @PluginAttribute(value="logQueueSize") int logQueueSize, @PluginAttribute(value="threadPoolSize") int threadPoolSize, @PluginAttribute(value="compressor") boolean compressor, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter) {
        if (env == null) {
            env = "default";
        }
        if (runModel != null) {
            LogMessageConstant.RUN_MODEL = Integer.parseInt(runModel);
        }
        if (kafkaClient == null) {
            kafkaClient = KafkaProducerClient.getInstance((String)kafkaHosts, (String)(compressor ? "lz4" : "none"));
        }
        if (expand != null && LogMessageConstant.EXPANDS.contains(expand)) {
            LogMessageConstant.EXPAND = expand;
        }
        if (maxCount == 0) {
            maxCount = 100;
        }
        if (logQueueSize == 0) {
            logQueueSize = 10000;
        }
        if (threadPoolSize == 0) {
            threadPoolSize = 1;
        }
        int count = maxCount;
        MessageAppenderFactory.initQueue((int)logQueueSize);
        for (int a = 0; a < threadPoolSize; ++a) {
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startRunLog((AbstractClient)kafkaClient, (int)count));
            threadPoolExecutor.execute(() -> MessageAppenderFactory.startTraceLog((AbstractClient)kafkaClient, (int)count));
        }
        return new KafkaAppender(name, appName, env, kafkaHosts, runModel, filter, layout, true, expand, maxCount, logQueueSize, threadPoolSize);
    }

    public void append(LogEvent logEvent) {
        if (logEvent != null) {
            this.send(logEvent);
        }
    }

    protected void send(LogEvent logEvent) {
        BaseLogMessage logMessage = LogMessageUtil.getLogMessage(this.appName, this.env, logEvent);
        if (logMessage instanceof RunLogMessage) {
            String message = LogMessageUtil.getLogMessage((RunLogMessage)logMessage, logEvent);
            MessageAppenderFactory.pushRundataQueue((String)message);
        } else {
            MessageAppenderFactory.pushTracedataQueue((String)GfJsonUtil.toJSONString((Object)logMessage));
        }
    }

    public String getAppName() {
        return this.appName;
    }

    public String getEnv() {
        return this.env;
    }

    public String getKafkaHosts() {
        return this.kafkaHosts;
    }

    public String getRunModel() {
        return this.runModel;
    }

    public String getExpand() {
        return this.expand;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public int getLogQueueSize() {
        return this.logQueueSize;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    static {
        threadPoolExecutor = ThreadPoolUtil.getPool();
    }
}

