/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.concurrent;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleanableExecutors {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanableExecutors.class);
    private static final String DEFAULT_POOL_NAME = "POWSYBL_POOL";

    private CleanableExecutors() {
    }

    private static ThreadFactory threadFactory(String poolName) {
        return new ThreadFactoryBuilder().setNameFormat(poolName + "-%d").build();
    }

    public static ExecutorService newFixedThreadPool(int nThreads) {
        return CleanableExecutors.newFixedThreadPool(DEFAULT_POOL_NAME, nThreads);
    }

    public static ExecutorService newFixedThreadPool(String poolName, int nThreads) {
        return CleanableExecutors.newFixedThreadPool(poolName, nThreads, ServiceLoader.load(ThreadCleaner.class, CleanableExecutors.class.getClassLoader()));
    }

    public static ExecutorService newFixedThreadPool(String poolName, int nThreads, Iterable<ThreadCleaner> cleaners) {
        return new CleanableThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), CleanableExecutors.threadFactory(poolName), cleaners);
    }

    public static ExecutorService newCachedThreadPool() {
        return CleanableExecutors.newCachedThreadPool(DEFAULT_POOL_NAME);
    }

    public static ExecutorService newCachedThreadPool(String poolName) {
        return CleanableExecutors.newCachedThreadPool(poolName, ServiceLoader.load(ThreadCleaner.class, CleanableExecutors.class.getClassLoader()));
    }

    public static ExecutorService newCachedThreadPool(String poolName, Iterable<ThreadCleaner> cleaners) {
        return new CleanableThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), CleanableExecutors.threadFactory(poolName), cleaners);
    }

    public static ExecutorService newSizeLimitedThreadPool(int maxSize) {
        return CleanableExecutors.newSizeLimitedThreadPool(DEFAULT_POOL_NAME, maxSize);
    }

    public static ExecutorService newSizeLimitedThreadPool(String poolName, int maxSize) {
        return CleanableExecutors.newSizeLimitedThreadPool(poolName, maxSize, ServiceLoader.load(ThreadCleaner.class, CleanableExecutors.class.getClassLoader()));
    }

    public static ExecutorService newSizeLimitedThreadPool(String poolName, int maxSize, Iterable<ThreadCleaner> cleaners) {
        if (maxSize < 1) {
            throw new IllegalArgumentException("Invalid bounded max size");
        }
        CleanableThreadPoolExecutor threadPoolExecutor = new CleanableThreadPoolExecutor(maxSize, maxSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), CleanableExecutors.threadFactory(poolName), cleaners);
        threadPoolExecutor.allowCoreThreadTimeOut(true);
        return threadPoolExecutor;
    }

    public static class CleanableThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final Iterable<ThreadCleaner> cleaners;

        public CleanableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, Iterable<ThreadCleaner> cleaners) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
            this.cleaners = Objects.requireNonNull(cleaners);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("activeCount={} ,corePoolSize={} ,largestPoolSize={} ,maximumPoolSize={}", new Object[]{this.getActiveCount(), this.getCorePoolSize(), this.getLargestPoolSize(), this.getMaximumPoolSize()});
            }
            if (t != null && LOGGER.isErrorEnabled()) {
                LOGGER.error(t.toString(), t);
            }
            for (ThreadCleaner cleaner : this.cleaners) {
                cleaner.clean();
            }
        }
    }

    public static interface ThreadCleaner {
        public void clean();
    }
}

