/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.exceptions.UncheckedClassNotFoundException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public abstract class AbstractModuleConfig
implements ModuleConfig {
    private static PowsyblException createPropertyNotSetException(String name) {
        return new PowsyblException("Property " + name + " is not set");
    }

    @Override
    public String getStringProperty(String name) {
        return this.getOptionalStringProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public String getStringProperty(String name, String defaultValue) {
        return this.getOptionalStringProperty(name).orElse(defaultValue);
    }

    @Override
    public List<String> getStringListProperty(String name) {
        return this.getOptionalStringListProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public List<String> getStringListProperty(String name, List<String> defaultValue) {
        return this.getOptionalStringListProperty(name).orElse(defaultValue);
    }

    @Override
    public <E extends Enum<E>> Optional<E> getOptionalEnumProperty(String name, Class<E> clazz) {
        return this.getOptionalStringProperty(name).map(s -> Enum.valueOf(clazz, s));
    }

    @Override
    public <E extends Enum<E>> E getEnumProperty(String name, Class<E> clazz) {
        return (E)((Enum)this.getOptionalEnumProperty(name, clazz).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name)));
    }

    @Override
    public <E extends Enum<E>> E getEnumProperty(String name, Class<E> clazz, E defaultValue) {
        return (E)((Enum)this.getOptionalEnumProperty(name, clazz).orElse(defaultValue));
    }

    @Override
    public <E extends Enum<E>> Optional<Set<E>> getOptionalEnumSetProperty(String name, Class<E> clazz) {
        return this.getOptionalStringListProperty(name).flatMap(strings -> Optional.of(strings.stream().map(s -> Enum.valueOf(clazz, s)).collect(Collectors.toSet())));
    }

    @Override
    public <E extends Enum<E>> Set<E> getEnumSetProperty(String name, Class<E> clazz) {
        return this.getOptionalEnumSetProperty(name, clazz).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public <E extends Enum<E>> Set<E> getEnumSetProperty(String name, Class<E> clazz, Set<E> defaultValue) {
        return this.getOptionalEnumSetProperty(name, clazz).orElse(defaultValue);
    }

    @Override
    public int getIntProperty(String name) {
        return this.getOptionalIntProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public int getIntProperty(String name, int defaultValue) {
        return this.getOptionalIntProperty(name).orElse(defaultValue);
    }

    @Override
    public long getLongProperty(String name) {
        return this.getOptionalLongProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public long getLongProperty(String name, long defaultValue) {
        return this.getOptionalLongProperty(name).orElse(defaultValue);
    }

    @Override
    public float getFloatProperty(String name) {
        return this.getOptionalFloatProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name)).floatValue();
    }

    @Override
    public float getFloatProperty(String name, float defaultValue) {
        return this.getOptionalFloatProperty(name).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    @Override
    public double getDoubleProperty(String name) {
        return this.getOptionalDoubleProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public double getDoubleProperty(String name, double defaultValue) {
        return this.getOptionalDoubleProperty(name).orElse(defaultValue);
    }

    @Override
    public boolean getBooleanProperty(String name) {
        return this.getOptionalBooleanProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public boolean getBooleanProperty(String name, boolean defaultValue) {
        return this.getOptionalBooleanProperty(name).orElse(defaultValue);
    }

    @Override
    public Path getPathProperty(String name) {
        return this.getOptionalPathProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public Path getPathProperty(String name, Path defaultValue) {
        return this.getOptionalPathProperty(name).orElse(defaultValue);
    }

    @Override
    public List<Path> getPathListProperty(String name) {
        return this.getOptionalPathListProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public <T> Optional<Class<? extends T>> getOptionalClassProperty(String name, Class<T> subClass) {
        return this.getOptionalStringProperty(name).map(s -> {
            try {
                return Class.forName(s).asSubclass(subClass);
            }
            catch (ClassNotFoundException e) {
                throw new UncheckedClassNotFoundException(e);
            }
        });
    }

    @Override
    public <T> Class<? extends T> getClassProperty(String name, Class<T> subClass) {
        return this.getOptionalClassProperty(name, subClass).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public <T> Class<? extends T> getClassProperty(String name, Class<T> subClass, Class<? extends T> defaultValue) {
        return this.getOptionalClassProperty(name, subClass).orElse(defaultValue);
    }

    @Override
    public DateTime getDateTimeProperty(String name) {
        return this.getOptionalDateTimeProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }

    @Override
    public Optional<Interval> getOptionalIntervalProperty(String name) {
        return this.getOptionalStringProperty(name).map(Interval::parse);
    }

    @Override
    public Interval getIntervalProperty(String name) {
        return this.getOptionalIntervalProperty(name).orElseThrow(() -> AbstractModuleConfig.createPropertyNotSetException(name));
    }
}

