/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.exceptions.UncheckedIllegalAccessException;
import com.powsybl.commons.exceptions.UncheckedInstantiationException;
import java.util.Objects;

public interface ComponentDefaultConfig {
    public static ComponentDefaultConfig load() {
        return Impl.getDefaultConfig();
    }

    public static ComponentDefaultConfig load(PlatformConfig platformConfig) {
        return new Impl(platformConfig.getOptionalModuleConfig("componentDefaultConfig").orElse(null));
    }

    public <T> Class<? extends T> findFactoryImplClass(Class<T> var1);

    public <T, U extends T> Class<? extends T> findFactoryImplClass(Class<T> var1, Class<U> var2);

    public <T> T newFactoryImpl(Class<T> var1);

    public <T, U extends T> T newFactoryImpl(Class<T> var1, Class<U> var2);

    public static class Impl
    implements ComponentDefaultConfig {
        private static ComponentDefaultConfig defaultConfig;
        private final ModuleConfig config;

        private static synchronized ComponentDefaultConfig getDefaultConfig() {
            if (defaultConfig == null) {
                defaultConfig = ComponentDefaultConfig.load(PlatformConfig.defaultConfig());
            }
            return defaultConfig;
        }

        public Impl(ModuleConfig config) {
            this.config = config;
        }

        @Override
        public <T> Class<? extends T> findFactoryImplClass(Class<T> factoryBaseClass) {
            Objects.requireNonNull(factoryBaseClass);
            String propertyName = factoryBaseClass.getSimpleName();
            if (this.config == null) {
                throw new PowsyblException("Property " + propertyName + " is not set");
            }
            return this.config.getClassProperty(propertyName, factoryBaseClass);
        }

        @Override
        public <T, U extends T> Class<? extends T> findFactoryImplClass(Class<T> factoryBaseClass, Class<U> defaultFactoryImplClass) {
            Objects.requireNonNull(factoryBaseClass);
            Objects.requireNonNull(defaultFactoryImplClass);
            String propertyName = factoryBaseClass.getSimpleName();
            return this.config != null ? this.config.getClassProperty(propertyName, factoryBaseClass, defaultFactoryImplClass) : defaultFactoryImplClass;
        }

        @Override
        public <T> T newFactoryImpl(Class<T> factoryBaseClass) {
            try {
                return this.findFactoryImplClass(factoryBaseClass).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new UncheckedIllegalAccessException(e);
            }
            catch (InstantiationException e) {
                throw new UncheckedInstantiationException(e);
            }
        }

        @Override
        public <T, U extends T> T newFactoryImpl(Class<T> factoryBaseClass, Class<U> defaultFactoryImplClass) {
            try {
                return this.findFactoryImplClass(factoryBaseClass, defaultFactoryImplClass).newInstance();
            }
            catch (IllegalAccessException e) {
                throw new UncheckedIllegalAccessException(e);
            }
            catch (InstantiationException e) {
                throw new UncheckedInstantiationException(e);
            }
        }
    }
}

