/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import com.powsybl.commons.config.EnvironmentMapModuleConfig;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.ModuleConfigRepository;
import java.nio.file.FileSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;

public final class EnvironmentModuleConfigRepository
implements ModuleConfigRepository {
    static final String SEPARATOR = "__";
    static final UnaryOperator<String> UPPER_UNDERSCORE_FORMATTER = name -> {
        if (name.toLowerCase().equals(name)) {
            return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, name);
        }
        if (Character.isUpperCase(name.charAt(0))) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
    };
    private final Map<String, String> filteredEnvVarMap = new HashMap<String, String>();
    private final FileSystem fs;

    public EnvironmentModuleConfigRepository(Map<String, String> map, FileSystem fileSystem) {
        this.fs = Objects.requireNonNull(fileSystem);
        Objects.requireNonNull(map);
        map.keySet().stream().filter(k -> k.toUpperCase().equals(k)).filter(k -> k.contains(SEPARATOR)).forEach(k -> this.filteredEnvVarMap.put((String)k, (String)map.get(k)));
    }

    @Override
    public Optional<ModuleConfig> getModuleConfig(String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return Optional.empty();
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        this.filteredEnvVarMap.keySet().stream().filter(k -> k.startsWith((String)UPPER_UNDERSCORE_FORMATTER.apply(name) + SEPARATOR)).forEach(k -> map.put(k, this.filteredEnvVarMap.get(k)));
        return map.isEmpty() ? Optional.empty() : Optional.of(new EnvironmentMapModuleConfig(map, this.fs, name));
    }
}

