/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.config.AbstractMapModuleConfig;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MapModuleConfig
extends AbstractMapModuleConfig {
    private final Map<Object, Object> properties;

    public MapModuleConfig(FileSystem fs) {
        this(new HashMap<Object, Object>(), fs);
    }

    public MapModuleConfig(Map<Object, Object> properties) {
        this(properties, FileSystems.getDefault());
    }

    public MapModuleConfig(Map<Object, Object> properties, FileSystem fs) {
        super(fs);
        this.properties = Objects.requireNonNull(properties);
    }

    @Override
    protected Object getValue(String propertyName) {
        return this.properties.get(propertyName);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.properties.entrySet().stream().map(Map.Entry::getKey).map(Object::toString).collect(Collectors.toSet());
    }

    public void setPathProperty(String name, Path path) {
        this.properties.put(name, path.toAbsolutePath().toString());
    }

    public <T> void setClassProperty(String name, Class<T> subClass) {
        Objects.requireNonNull(subClass);
        this.setStringProperty(name, subClass.getName());
    }

    public void setStringProperty(String name, String value) {
        Objects.requireNonNull(name);
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
    }

    public void setStringListProperty(String name, List<String> value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.properties.put(name, value);
    }
}

