/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.ModuleConfigRepository;
import com.powsybl.commons.config.PlatformConfigProvider;
import com.powsybl.commons.config.PropertiesModuleConfigRepository;
import com.powsybl.commons.config.XmlModuleConfigRepository;
import com.powsybl.commons.config.YamlModuleConfigRepository;
import com.powsybl.commons.io.FileUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformConfig.class);
    private static PlatformConfig defaultConfig;
    protected final Path configDir;
    protected final Supplier<ModuleConfigRepository> repositorySupplier;

    @Deprecated
    public static synchronized void setDefaultConfig(PlatformConfig defaultConfig) {
        PlatformConfig.defaultConfig = defaultConfig;
    }

    public static ModuleConfigRepository loadModuleRepository(Path configDir, String configName) {
        Path yamlConfigFile = configDir.resolve(configName + ".yml");
        if (Files.exists(yamlConfigFile, new LinkOption[0])) {
            LOGGER.info("Platform configuration defined by YAML file {}", (Object)yamlConfigFile);
            return new YamlModuleConfigRepository(yamlConfigFile);
        }
        Path xmlConfigFile = configDir.resolve(configName + ".xml");
        if (Files.exists(xmlConfigFile, new LinkOption[0])) {
            LOGGER.info("Platform configuration defined by XML file {}", (Object)xmlConfigFile);
            return new XmlModuleConfigRepository(xmlConfigFile);
        }
        LOGGER.info("Platform configuration defined by .properties files of directory {}", (Object)configDir);
        return new PropertiesModuleConfigRepository(configDir);
    }

    public static synchronized PlatformConfig defaultConfig() {
        if (defaultConfig == null) {
            ArrayList providers = Lists.newArrayList(ServiceLoader.load(PlatformConfigProvider.class, PlatformConfig.class.getClassLoader()));
            if (providers.isEmpty()) {
                LOGGER.info("Platform configuration provider not found. In order to customize the platform configuration, consider using powsybl-config-classic artifact, or powsybl-config-test for tests.");
                defaultConfig = new PlatformConfig(new EmptyModuleConfigRepository(), null);
            } else {
                if (providers.size() > 1) {
                    LOGGER.error("Multiple platform configuration providers found: {}", (Object)providers);
                    throw new PowsyblException("Multiple platform configuration providers found");
                }
                PlatformConfigProvider p = (PlatformConfigProvider)providers.get(0);
                LOGGER.info("Using platform configuration provider {}", (Object)p.getName());
                defaultConfig = p.getPlatformConfig();
            }
        }
        return defaultConfig;
    }

    public PlatformConfig(ModuleConfigRepository repository, Path configDir) {
        this((Supplier<ModuleConfigRepository>)((Supplier)() -> repository), configDir);
    }

    protected PlatformConfig(Supplier<ModuleConfigRepository> repositorySupplier, Path configDir) {
        this.repositorySupplier = Suppliers.memoize(Objects.requireNonNull(repositorySupplier));
        this.configDir = configDir != null ? FileUtil.createDirectory(configDir) : null;
    }

    public Optional<Path> getConfigDir() {
        return Optional.ofNullable(this.configDir);
    }

    protected ModuleConfigRepository getRepository() {
        return Objects.requireNonNull((ModuleConfigRepository)this.repositorySupplier.get());
    }

    @Deprecated
    public boolean moduleExists(String name) {
        return this.getOptionalModuleConfig(name).isPresent();
    }

    @Deprecated
    public ModuleConfig getModuleConfig(String name) {
        return this.getRepository().getModuleConfig(name).orElseThrow(() -> new PowsyblException("Module " + name + " not found"));
    }

    public Optional<ModuleConfig> getOptionalModuleConfig(String name) {
        return this.getRepository().getModuleConfig(name);
    }

    private static class EmptyModuleConfigRepository
    implements ModuleConfigRepository {
        private EmptyModuleConfigRepository() {
        }

        @Override
        public Optional<ModuleConfig> getModuleConfig(String name) {
            return Optional.empty();
        }
    }
}

