/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.config;

import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.ModuleConfigRepository;
import com.powsybl.commons.config.StackedModuleConfig;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StackedModuleConfigRepository
implements ModuleConfigRepository {
    private final List<ModuleConfigRepository> repositories;

    public StackedModuleConfigRepository(ModuleConfigRepository ... repositories) {
        this(Arrays.asList(repositories));
    }

    public StackedModuleConfigRepository(List<ModuleConfigRepository> repositories) {
        this.repositories = Objects.requireNonNull(repositories);
    }

    @Override
    public Optional<ModuleConfig> getModuleConfig(String name) {
        ModuleConfig stackedConfig = null;
        for (ModuleConfigRepository repository : this.repositories) {
            Optional<ModuleConfig> config = repository.getModuleConfig(name);
            if (!config.isPresent()) continue;
            if (stackedConfig == null) {
                stackedConfig = config.get();
                continue;
            }
            stackedConfig = new StackedModuleConfig(stackedConfig, config.get());
        }
        return Optional.ofNullable(stackedConfig);
    }
}

