/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.FileDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzFileDataSource
extends FileDataSource {
    public GzFileDataSource(Path directory, String baseName, DataSourceObserver observer) {
        super(directory, baseName, observer);
    }

    public GzFileDataSource(Path directory, String baseName) {
        super(directory, baseName);
    }

    @Override
    protected String getCompressionExt() {
        return ".gz";
    }

    @Override
    protected InputStream getCompressedInputStream(InputStream is) throws IOException {
        return new GZIPInputStream(is);
    }

    @Override
    protected OutputStream getCompressedOutputStream(OutputStream os) throws IOException {
        return new GZIPOutputStream(os);
    }
}

