/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ResourceSet {
    private final String dir;
    private final List<String> fileNames;

    public ResourceSet(String dir, String ... fileNames) {
        this(dir, Arrays.asList(fileNames));
    }

    public ResourceSet(String dir, List<String> fileNames) {
        this.dir = Objects.requireNonNull(dir);
        this.fileNames = Objects.requireNonNull(fileNames);
        for (String fileName : fileNames) {
            String resourceName = ResourceSet.getResourceName(dir, fileName);
            if (this.getClass().getResourceAsStream(resourceName) != null) continue;
            throw new IllegalArgumentException("Resource '" + resourceName + "' not found");
        }
    }

    private static String getResourceName(String dir, String fileName) {
        return dir.endsWith("/") ? dir + fileName : dir + "/" + fileName;
    }

    public String getDir() {
        return this.dir;
    }

    public List<String> getFileNames() {
        return this.fileNames;
    }

    public boolean exists(String fileName) {
        Objects.requireNonNull(fileName);
        return this.fileNames.contains(fileName);
    }

    public InputStream newInputStream(String fileName) {
        Objects.requireNonNull(fileName);
        if (!this.fileNames.contains(fileName)) {
            throw new IllegalArgumentException("File '" + fileName + "' not found");
        }
        return this.getClass().getResourceAsStream(ResourceSet.getResourceName(this.dir, fileName));
    }
}

