/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.datasource;

import com.powsybl.commons.datasource.DataSourceObserver;
import com.powsybl.commons.datasource.FileDataSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;

public class XZFileDataSource
extends FileDataSource {
    public XZFileDataSource(Path directory, String baseName, DataSourceObserver observer) {
        super(directory, baseName, observer);
    }

    public XZFileDataSource(Path directory, String baseName) {
        super(directory, baseName);
    }

    @Override
    protected String getCompressionExt() {
        return ".xz";
    }

    @Override
    protected InputStream getCompressedInputStream(InputStream is) throws IOException {
        return new XZCompressorInputStream((InputStream)new BufferedInputStream(is));
    }

    @Override
    protected OutputStream getCompressedOutputStream(OutputStream os) throws IOException {
        return new XZCompressorOutputStream((OutputStream)new BufferedOutputStream(os));
    }
}

