/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.io;

import com.powsybl.commons.io.FileUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class WorkingDirectory
implements AutoCloseable {
    private final Path path;
    private final boolean debug;
    private boolean closed;

    public WorkingDirectory(Path parentDir, String prefix, boolean debug) throws IOException {
        this.path = Files.createTempDirectory(parentDir, prefix, new FileAttribute[0]);
        this.debug = debug;
        this.closed = false;
    }

    public Path toPath() {
        return this.path;
    }

    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.debug && !this.closed) {
            FileUtil.removeDir(this.path);
            this.closed = true;
        }
    }
}

