/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.io.table;

import com.powsybl.commons.io.table.HorizontalAlignment;
import java.text.NumberFormat;
import java.util.Objects;

public class Column {
    private final String name;
    private HorizontalAlignment horizontalAlignment;
    private HorizontalAlignment titleHorizontalAlignment;
    private NumberFormat numberFormat = null;
    private int colspan = 1;

    public Column(String name) {
        this.name = Objects.requireNonNull(name);
        this.horizontalAlignment = HorizontalAlignment.LEFT;
        this.titleHorizontalAlignment = HorizontalAlignment.LEFT;
    }

    public String getName() {
        return this.name;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public HorizontalAlignment getTitleHorizontalAlignment() {
        return this.titleHorizontalAlignment;
    }

    public Column setTitleHorizontalAlignment(HorizontalAlignment titleHorizontalAlignment) {
        this.titleHorizontalAlignment = Objects.requireNonNull(titleHorizontalAlignment);
        return this;
    }

    public Column setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = Objects.requireNonNull(horizontalAlignment);
        return this;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public Column setNumberFormat(NumberFormat numberFormat) {
        this.numberFormat = Objects.requireNonNull(numberFormat);
        return this;
    }

    public int getColspan() {
        return this.colspan;
    }

    public Column setColspan(int colspan) {
        this.colspan = Column.checkColspan(colspan);
        return this;
    }

    private static int checkColspan(int colspan) {
        if (colspan < 1) {
            throw new IllegalArgumentException("colspan must be greater than 0");
        }
        return colspan;
    }
}

