/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.parameters;

import com.powsybl.commons.config.ModuleConfig;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.parameters.Parameter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;

public class ParameterDefaultValueConfig {
    private static final String MODULE_NAME = "import-export-parameters-default-value";
    public static final ParameterDefaultValueConfig INSTANCE = new ParameterDefaultValueConfig();
    private PlatformConfig platformConfig;
    private boolean init = false;
    private ModuleConfig configCache;

    public ParameterDefaultValueConfig() {
        this(null);
    }

    public ParameterDefaultValueConfig(PlatformConfig platformConfig) {
        this.platformConfig = platformConfig;
    }

    private synchronized ModuleConfig getModuleConfig() {
        if (!this.init) {
            if (this.platformConfig == null) {
                this.platformConfig = PlatformConfig.defaultConfig();
            }
            this.configCache = this.platformConfig.getOptionalModuleConfig(MODULE_NAME).orElse(null);
            this.init = true;
        }
        return this.configCache;
    }

    public Object getValue(String prefix, Parameter parameter) {
        Objects.requireNonNull(parameter);
        switch (parameter.getType()) {
            case BOOLEAN: {
                return this.getBooleanValue(prefix, parameter);
            }
            case STRING: {
                return this.getStringValue(prefix, parameter);
            }
            case STRING_LIST: {
                return this.getStringListValue(prefix, parameter);
            }
            case DOUBLE: {
                return this.getDoubleValue(prefix, parameter);
            }
            case INTEGER: {
                return this.getIntegerValue(prefix, parameter);
            }
        }
        throw new IllegalStateException("Unsupported parameter type: " + parameter.getType());
    }

    public boolean getBooleanValue(String prefix, Parameter parameter) {
        return this.getValue(prefix, (Boolean)parameter.getDefaultValue(), parameter, ModuleConfig::getOptionalBooleanProperty);
    }

    public String getStringValue(String prefix, Parameter parameter) {
        return this.getValue(prefix, (String)parameter.getDefaultValue(), parameter, ModuleConfig::getOptionalStringProperty);
    }

    public List<String> getStringListValue(String prefix, Parameter parameter) {
        return this.getValue(prefix, (List)parameter.getDefaultValue(), parameter, ModuleConfig::getOptionalStringListProperty);
    }

    public double getDoubleValue(String prefix, Parameter parameter) {
        return this.getValue(prefix, (Double)parameter.getDefaultValue(), parameter, (moduleConfig, name) -> moduleConfig.getOptionalDoubleProperty((String)name).stream().boxed().findFirst());
    }

    public int getIntegerValue(String prefix, Parameter parameter) {
        return this.getValue(prefix, (Integer)parameter.getDefaultValue(), parameter, (moduleConfig, name) -> moduleConfig.getOptionalIntProperty((String)name).stream().boxed().findFirst());
    }

    private <T> T getValue(String prefix, T defaultValue, Parameter parameter, BiFunction<ModuleConfig, String, Optional<T>> valueSupplier) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(parameter);
        ModuleConfig moduleConfig = this.getModuleConfig();
        if (moduleConfig != null) {
            for (String name : parameter.getNames()) {
                Object value = valueSupplier.apply(moduleConfig, name).orElseGet(() -> ((Optional)valueSupplier.apply(moduleConfig, prefix + "_" + name)).orElse(null));
                if (value == null) continue;
                return (T)value;
            }
        }
        return defaultValue;
    }
}

