/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.commons.reporter;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.powsybl.commons.reporter.ReportBuilder;
import com.powsybl.commons.reporter.TypedValue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Report {
    public static final String REPORT_SEVERITY_KEY = "reportSeverity";
    private final String reportKey;
    private final String defaultMessage;
    private final Map<String, TypedValue> values;

    public Report(String reportKey, String defaultMessage, Map<String, TypedValue> values) {
        this.reportKey = Objects.requireNonNull(reportKey);
        this.defaultMessage = defaultMessage;
        this.values = new HashMap<String, TypedValue>();
        Objects.requireNonNull(values).forEach(this::addTypedValue);
    }

    private void addTypedValue(String key, TypedValue typedValue) {
        Objects.requireNonNull(typedValue);
        this.values.put(key, typedValue);
    }

    public static ReportBuilder builder() {
        return new ReportBuilder();
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public String getReportKey() {
        return this.reportKey;
    }

    public TypedValue getValue(String valueKey) {
        return this.values.get(valueKey);
    }

    public Map<String, TypedValue> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public static Report parseJsonNode(JsonNode jsonNode, Map<String, String> dictionary, ObjectCodec codec) throws IOException {
        JsonNode reportKeyNode = jsonNode.get("reportKey");
        String reportKey = (String)codec.readValue(reportKeyNode.traverse(), String.class);
        JsonNode taskValuesNode = jsonNode.get("values");
        Map taskValues = taskValuesNode == null ? Collections.emptyMap() : (Map)codec.readValue(taskValuesNode.traverse(codec), (TypeReference)new TypeReference<HashMap<String, TypedValue>>(){});
        String defaultMessage = dictionary.getOrDefault(reportKey, "(missing report key in dictionary)");
        return new Report(reportKey, defaultMessage, taskValues);
    }
}

