/* Copyright 2012 predic8 GmbH, www.predic8.com

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License. */

package com.predic8.schema;

import groovy.xml.*
import groovy.namespace.*

import com.predic8.soamodel.AbstractDiffGenerator;
import com.predic8.soamodel.CreatorContext 
import com.predic8.soamodel.DiffGeneratorContext;
import com.predic8.wstool.creator.*

import javax.xml.stream.*

class GroupRef extends SchemaComponent{

  QName ref
  def minOccurs = 1
  def maxOccurs = 1
  
  protected parseAttributes(token, params){
	minOccurs = token.getAttributeValue( null , 'minOccurs') ?: 1
	maxOccurs = token.getAttributeValue( null , 'maxOccurs') ?: 1
  }

  def create(creator, CreatorContext ctx){
    creator.createGroupRef(this, ctx)
  }

  def compare(AbstractDiffGenerator generator, other, DiffGeneratorContext ctx = new DiffGeneratorContext()){
    generator.compareGroupRef( this, other, ctx)
  }
  
  public boolean equals(obj) {
    obj && getClass() == obj.getClass() && ref == obj.ref
  }
  
  public getElementName(){
    'group'
  }
  
}

