/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.sizes;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;

public class MethodLengthCheck
extends Check {
    private boolean mCountEmpty = true;
    private static final int DEFAULT_MAX_LINES = 150;
    private int mMax = 150;

    public int[] getDefaultTokens() {
        return new int[]{9, 8};
    }

    public void visitToken(DetailAST aAST) {
        DetailAST openingBrace = aAST.findFirstToken(7);
        if (openingBrace != null) {
            DetailAST closingBrace = openingBrace.findFirstToken(73);
            int length = closingBrace.getLineNo() - openingBrace.getLineNo() + 1;
            if (!this.mCountEmpty) {
                FileContents contents = this.getFileContents();
                int lastLine = closingBrace.getLineNo();
                for (int i = openingBrace.getLineNo() - 1; i < lastLine; ++i) {
                    if (!contents.lineIsBlank(i) && !contents.lineIsComment(i)) continue;
                    --length;
                }
            }
            if (length > this.mMax) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "maxLen.method", length, this.mMax);
            }
        }
    }

    public void setMax(int aLength) {
        this.mMax = aLength;
    }

    public void setCountEmpty(boolean aCountEmpty) {
        this.mCountEmpty = aCountEmpty;
    }
}

