/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.google.common.base.CharMatcher;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtils;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtils;
import java.util.regex.Pattern;

public class SummaryJavadocCheck
extends AbstractJavadocCheck {
    public static final String SUMMARY_FIRST_SENTENCE = "summary.first.sentence";
    public static final String SUMMARY_JAVADOC = "summary.javaDoc";
    private static final Pattern JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN = Pattern.compile("\n[ ]+(\\*)|^[ ]+(\\*)");
    private static final String PERIOD = ".";
    private Pattern forbiddenSummaryFragments = CommonUtils.createPattern("^$");
    private String period = ".";

    public void setForbiddenSummaryFragments(String pattern) {
        this.forbiddenSummaryFragments = CommonUtils.createPattern(pattern);
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{10000};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{145};
    }

    @Override
    public int[] getRequiredTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        String firstSentence = SummaryJavadocCheck.getFirstSentence(ast);
        int endOfSentence = firstSentence.lastIndexOf(this.period);
        if (endOfSentence == -1) {
            this.log(ast.getLineNumber(), SUMMARY_FIRST_SENTENCE, new Object[0]);
        } else if (this.containsForbiddenFragment(firstSentence = firstSentence.substring(0, endOfSentence))) {
            this.log(ast.getLineNumber(), SUMMARY_JAVADOC, new Object[0]);
        }
    }

    private static String getFirstSentence(DetailNode ast) {
        StringBuilder result = new StringBuilder();
        String periodSuffix = ". ";
        for (DetailNode child : ast.getChildren()) {
            if (child.getType() != 10072 && child.getText().contains(". ")) {
                result.append(SummaryJavadocCheck.getCharsTillDot(child));
                break;
            }
            result.append(child.getText());
        }
        return result.toString();
    }

    private static String getCharsTillDot(DetailNode textNode) {
        StringBuilder result = new StringBuilder();
        for (DetailNode child : textNode.getChildren()) {
            result.append(child.getText());
            if (PERIOD.equals(child.getText()) && JavadocUtils.getNextSibling(child).getType() == 4) break;
        }
        return result.toString();
    }

    private boolean containsForbiddenFragment(String firstSentence) {
        String javadocText = JAVADOC_MULTILINE_TO_SINGLELINE_PATTERN.matcher(firstSentence).replaceAll(" ");
        javadocText = CharMatcher.WHITESPACE.trimAndCollapseFrom((CharSequence)javadocText, ' ');
        return this.forbiddenSummaryFragments.matcher(javadocText).find();
    }
}

