/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.whitespace.AbstractParenPadCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;

public class ParenPadCheck
extends AbstractParenPadCheck {
    private final int[] acceptableTokens = ParenPadCheck.makeAcceptableTokens();

    public ParenPadCheck() {
        Arrays.sort(this.acceptableTokens);
    }

    @Override
    public int[] getDefaultTokens() {
        return ParenPadCheck.makeAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return ParenPadCheck.makeAcceptableTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 27: {
                this.processLeft(ast);
                this.processRight(ast.findFirstToken(77));
                break;
            }
            case 28: 
            case 59: 
            case 109: {
                this.processExpression(ast);
                break;
            }
            case 91: {
                this.visitLiteralFor(ast);
                break;
            }
            case 67: 
            case 136: 
            case 155: 
            case 159: 
            case 181: {
                this.visitTokenWithOptionalParentheses(ast);
                break;
            }
            case 176: {
                this.visitResourceSpecification(ast);
                break;
            }
            default: {
                this.processLeft(ast.findFirstToken(76));
                this.processRight(ast.findFirstToken(77));
            }
        }
    }

    private void visitTokenWithOptionalParentheses(DetailAST ast) {
        DetailAST parenAst = ast.findFirstToken(76);
        if (parenAst != null) {
            this.processLeft(parenAst);
            this.processRight(ast.findFirstToken(77));
        }
    }

    private void visitResourceSpecification(DetailAST ast) {
        this.processLeft(ast.findFirstToken(76));
        DetailAST rparen = ast.findFirstToken(77);
        if (!ParenPadCheck.hasPrecedingSemiColon(rparen)) {
            this.processRight(rparen);
        }
    }

    private static boolean hasPrecedingSemiColon(DetailAST ast) {
        return ast.getPreviousSibling().getType() == 45;
    }

    private void visitLiteralFor(DetailAST ast) {
        DetailAST rparen;
        DetailAST lparen = ast.findFirstToken(76);
        if (!ParenPadCheck.isPrecedingEmptyForInit(lparen)) {
            this.processLeft(lparen);
        }
        if (!ParenPadCheck.isFollowsEmptyForIterator(rparen = ast.findFirstToken(77))) {
            this.processRight(rparen);
        }
    }

    private void processExpression(DetailAST ast) {
        for (DetailAST childAst = ast.getFirstChild(); childAst != null; childAst = childAst.getNextSibling()) {
            if (childAst.getType() == 76) {
                this.processLeft(childAst);
                continue;
            }
            if (childAst.getType() == 77 && !ParenPadCheck.isInTypecast(childAst)) {
                this.processRight(childAst);
                continue;
            }
            if (this.isAcceptableToken(childAst)) continue;
            this.processExpression(childAst);
        }
    }

    private boolean isAcceptableToken(DetailAST ast) {
        boolean result = false;
        if (Arrays.binarySearch(this.acceptableTokens, ast.getType()) >= 0) {
            result = true;
        }
        return result;
    }

    private static int[] makeAcceptableTokens() {
        return new int[]{159, 161, 43, 8, 59, 155, 28, 96, 85, 91, 83, 136, 89, 67, 84, 27, 9, 109, 176, 42, 181, 199};
    }

    private static boolean isInTypecast(DetailAST ast) {
        DetailAST firstRparen;
        boolean result = false;
        if (ast.getParent().getType() == 23 && TokenUtil.areOnSameLine(firstRparen = ast.getParent().findFirstToken(77), ast) && firstRparen.getColumnNo() == ast.getColumnNo()) {
            result = true;
        }
        return result;
    }

    private static boolean isFollowsEmptyForIterator(DetailAST ast) {
        boolean result = false;
        DetailAST parent = ast.getParent();
        if (parent.findFirstToken(156) == null) {
            DetailAST forIterator = parent.findFirstToken(37);
            result = !forIterator.hasChildren();
        }
        return result;
    }

    private static boolean isPrecedingEmptyForInit(DetailAST ast) {
        boolean result = false;
        DetailAST parent = ast.getParent();
        if (parent.findFirstToken(156) == null) {
            DetailAST forIterator = parent.findFirstToken(35);
            result = !forIterator.hasChildren();
        }
        return result;
    }
}

