/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.meta.ModulePropertyDetails;
import com.puppycrawl.tools.checkstyle.meta.ModuleType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ModuleDetails {
    private final List<ModulePropertyDetails> properties = new ArrayList<ModulePropertyDetails>();
    private final Map<String, ModulePropertyDetails> modulePropertyKeyMap = new HashMap<String, ModulePropertyDetails>();
    private final List<String> violationMessageKeys = new ArrayList<String>();
    private String name;
    private String fullQualifiedName;
    private String parent;
    private String description;
    private ModuleType moduleType;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullQualifiedName() {
        return this.fullQualifiedName;
    }

    public void setFullQualifiedName(String fullQualifiedName) {
        this.fullQualifiedName = fullQualifiedName;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ModulePropertyDetails> getProperties() {
        return Collections.unmodifiableList(this.properties);
    }

    public void addToProperties(ModulePropertyDetails property) {
        this.properties.add(property);
        this.modulePropertyKeyMap.put(property.getName(), property);
    }

    public void addToProperties(List<ModulePropertyDetails> modulePropertyDetailsList) {
        this.properties.addAll(modulePropertyDetailsList);
        modulePropertyDetailsList.forEach(modulePropertyDetails -> this.modulePropertyKeyMap.put(modulePropertyDetails.getName(), (ModulePropertyDetails)modulePropertyDetails));
    }

    public List<String> getViolationMessageKeys() {
        return Collections.unmodifiableList(this.violationMessageKeys);
    }

    public void addToViolationMessages(String msg) {
        this.violationMessageKeys.add(msg);
    }

    public void addToViolationMessages(List<String> msgList) {
        this.violationMessageKeys.addAll(msgList);
    }

    public ModulePropertyDetails getModulePropertyByKey(String key) {
        return this.modulePropertyKeyMap.get(key);
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }
}

