/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.CopyObjectRequest;
import com.qcloud.cos.model.CopyObjectResult;
import com.qcloud.cos.model.CopyResult;
import com.qcloud.cos.region.Region;
import com.qcloud.cos.transfer.Copy;
import com.qcloud.cos.transfer.TransferManager;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CopyFileDemo {
    public static void copySmallFileDemo() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        Region srcBucketRegion = new Region("ap-shanghai");
        String srcBucketName = "srcBucket-1251668577";
        String srcKey = "aaa/bbb.txt";
        String destBucketName = "destBucket-1251668577";
        String destKey = "ccc/ddd.txt";
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        try {
            CopyObjectResult copyObjectResult = cosclient.copyObject(copyObjectRequest);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        cosclient.shutdown();
    }

    public static void copyBigFileDemo() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        ExecutorService threadPool = Executors.newFixedThreadPool(32);
        TransferManager transferManager = new TransferManager(cosclient, threadPool);
        Region srcBucketRegion = new Region("ap-shanghai");
        String srcBucketName = "srcBucket-1251668577";
        String srcKey = "aaa/bbb.txt";
        String destBucketName = "destBucket-1251668577";
        String destKey = "ccc/ddd.txt";
        COSClient srcCOSClient = new COSClient(cred, new ClientConfig(srcBucketRegion));
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(srcBucketRegion, srcBucketName, srcKey, destBucketName, destKey);
        try {
            Copy copy = transferManager.copy(copyObjectRequest, srcCOSClient, null);
            CopyResult copyResult = copy.waitForCopyResult();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        transferManager.shutdownNow();
        srcCOSClient.shutdown();
        cosclient.shutdown();
    }
}

