/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal;

import com.qcloud.cos.event.ProgressListener;
import com.qcloud.cos.internal.ReadLimitInfo;
import com.qcloud.cos.internal.RequestClientOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CosServiceRequest
implements Cloneable,
ReadLimitInfo {
    private ProgressListener progressListener = ProgressListener.NOOP;
    private Map<String, String> customRequestHeaders;
    private Map<String, List<String>> customQueryParameters;
    private final RequestClientOptions requestClientOptions = new RequestClientOptions();

    public void setGeneralProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener == null ? ProgressListener.NOOP : progressListener;
    }

    public ProgressListener getGeneralProgressListener() {
        return this.progressListener;
    }

    public <T extends CosServiceRequest> T withGeneralProgressListener(ProgressListener progressListener) {
        this.setGeneralProgressListener(progressListener);
        CosServiceRequest t = this;
        return (T)t;
    }

    public Map<String, String> getCustomRequestHeaders() {
        if (this.customRequestHeaders == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customRequestHeaders);
    }

    public String putCustomRequestHeader(String name, String value) {
        if (this.customRequestHeaders == null) {
            this.customRequestHeaders = new HashMap<String, String>();
        }
        if (name == null) {
            throw new IllegalArgumentException("custom header key cann't be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("custom header value cann't be null");
        }
        return this.customRequestHeaders.put(name, value);
    }

    public Map<String, List<String>> getCustomQueryParameters() {
        if (this.customQueryParameters == null) {
            return null;
        }
        return Collections.unmodifiableMap(this.customQueryParameters);
    }

    public void putCustomQueryParameter(String name, String value) {
        List<String> paramList;
        if (this.customQueryParameters == null) {
            this.customQueryParameters = new HashMap<String, List<String>>();
        }
        if ((paramList = this.customQueryParameters.get(name)) == null) {
            paramList = new LinkedList<String>();
            this.customQueryParameters.put(name, paramList);
        }
        paramList.add(value);
    }

    public RequestClientOptions getRequestClientOptions() {
        return this.requestClientOptions;
    }

    protected final <T extends CosServiceRequest> T copyBaseTo(T target) {
        if (this.customRequestHeaders != null) {
            for (Map.Entry<String, Object> entry : this.customRequestHeaders.entrySet()) {
                target.putCustomRequestHeader(entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.customQueryParameters != null) {
            for (Map.Entry<String, Object> entry : this.customQueryParameters.entrySet()) {
                if (entry.getValue() == null) continue;
                for (String value : (List)entry.getValue()) {
                    target.putCustomQueryParameter(entry.getKey(), value);
                }
            }
        }
        target.setGeneralProgressListener(this.progressListener);
        this.requestClientOptions.copyTo(target.getRequestClientOptions());
        return target;
    }

    @Override
    public int getReadLimit() {
        return this.requestClientOptions.getReadLimit();
    }
}

