/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.model;

import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.model.AccessControlList;
import com.qcloud.cos.model.CannedAccessControlList;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.SSECOSKeyManagementParams;
import com.qcloud.cos.model.SSECOSKeyManagementParamsProvider;
import com.qcloud.cos.model.SSECustomerKey;
import com.qcloud.cos.model.SSECustomerKeyProvider;
import com.qcloud.cos.model.StorageClass;
import java.io.Serializable;

public class InitiateMultipartUploadRequest
extends CosServiceRequest
implements SSECustomerKeyProvider,
SSECOSKeyManagementParamsProvider,
Serializable {
    private String bucketName;
    private String key;
    public ObjectMetadata objectMetadata;
    private CannedAccessControlList cannedACL;
    private AccessControlList accessControlList;
    private StorageClass storageClass;
    private String redirectLocation;
    private SSECustomerKey sseCustomerKey;
    private SSECOSKeyManagementParams sseCOSKeyManagementParams;

    public InitiateMultipartUploadRequest(String bucketName, String key) {
        this.bucketName = bucketName;
        this.key = key;
    }

    public InitiateMultipartUploadRequest(String bucketName, String key, ObjectMetadata objectMetadata) {
        this.bucketName = bucketName;
        this.key = key;
        this.objectMetadata = objectMetadata;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public InitiateMultipartUploadRequest withBucketName(String bucketName) {
        this.bucketName = bucketName;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public InitiateMultipartUploadRequest withKey(String key) {
        this.key = key;
        return this;
    }

    public CannedAccessControlList getCannedACL() {
        return this.cannedACL;
    }

    public void setCannedACL(CannedAccessControlList cannedACL) {
        this.cannedACL = cannedACL;
    }

    public InitiateMultipartUploadRequest withCannedACL(CannedAccessControlList acl) {
        this.cannedACL = acl;
        return this;
    }

    public AccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setAccessControlList(AccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public InitiateMultipartUploadRequest withAccessControlList(AccessControlList accessControlList) {
        this.setAccessControlList(accessControlList);
        return this;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
    }

    public InitiateMultipartUploadRequest withStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass;
        return this;
    }

    public InitiateMultipartUploadRequest withStorageClass(String storageClass) {
        this.storageClass = storageClass != null ? StorageClass.fromValue(storageClass) : null;
        return this;
    }

    public ObjectMetadata getObjectMetadata() {
        return this.objectMetadata;
    }

    public void setObjectMetadata(ObjectMetadata objectMetadata) {
        this.objectMetadata = objectMetadata;
    }

    public InitiateMultipartUploadRequest withObjectMetadata(ObjectMetadata objectMetadata) {
        this.setObjectMetadata(objectMetadata);
        return this;
    }

    public void setRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
    }

    public String getRedirectLocation() {
        return this.redirectLocation;
    }

    public InitiateMultipartUploadRequest withRedirectLocation(String redirectLocation) {
        this.redirectLocation = redirectLocation;
        return this;
    }

    @Override
    public SSECustomerKey getSSECustomerKey() {
        return this.sseCustomerKey;
    }

    public void setSSECustomerKey(SSECustomerKey sseKey) {
        if (sseKey != null && this.sseCOSKeyManagementParams != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSECOSKeyManagementParams must not be set at the same time.");
        }
        this.sseCustomerKey = sseKey;
    }

    public InitiateMultipartUploadRequest withSSECustomerKey(SSECustomerKey sseKey) {
        this.setSSECustomerKey(sseKey);
        return this;
    }

    @Override
    public SSECOSKeyManagementParams getSSECOSKeyManagementParams() {
        return this.sseCOSKeyManagementParams;
    }

    public void setSSECOSKeyManagementParams(SSECOSKeyManagementParams params) {
        if (params != null && this.sseCustomerKey != null) {
            throw new IllegalArgumentException("Either SSECustomerKey or SSECOSKeyManagementParams must not be set at the same time.");
        }
        this.sseCOSKeyManagementParams = params;
    }

    public InitiateMultipartUploadRequest withSSECOSKeyManagementParams(SSECOSKeyManagementParams sseCOSKeyManagementParams) {
        this.setSSECOSKeyManagementParams(sseCOSKeyManagementParams);
        return this;
    }
}

