/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.exception.CosServiceException;
import com.qcloud.cos.model.AbortMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadRequest;
import com.qcloud.cos.model.CompleteMultipartUploadResult;
import com.qcloud.cos.model.CopyPartRequest;
import com.qcloud.cos.model.CopyPartResult;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.InitiateMultipartUploadResult;
import com.qcloud.cos.model.ListPartsRequest;
import com.qcloud.cos.model.PartETag;
import com.qcloud.cos.model.PartListing;
import com.qcloud.cos.model.PartSummary;
import com.qcloud.cos.model.StorageClass;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.model.UploadPartResult;
import com.qcloud.cos.region.Region;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import java.util.List;

public class MultipartUploadDemo {
    public static String InitMultipartUploadDemo() {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "test-xxx";
        String key = "aaa/bbb.txt";
        InitiateMultipartUploadRequest request = new InitiateMultipartUploadRequest(bucketName, key);
        request.setStorageClass(StorageClass.Standard);
        try {
            String uploadId;
            InitiateMultipartUploadResult initResult = cosclient.initiateMultipartUpload(request);
            String string = uploadId = initResult.getUploadId();
            return string;
        }
        catch (CosServiceException e) {
            throw e;
        }
        catch (CosClientException e) {
            throw e;
        }
        finally {
            cosclient.shutdown();
        }
    }

    public static List<PartETag> listPartDemo(String uploadId) {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "test-xxx";
        String key = "aaa/bbb.txt";
        LinkedList<PartETag> partETags = new LinkedList<PartETag>();
        PartListing partListing = null;
        ListPartsRequest listPartsRequest = new ListPartsRequest(bucketName, key, uploadId);
        do {
            try {
                partListing = cosclient.listParts(listPartsRequest);
            }
            catch (CosServiceException e) {
                throw e;
            }
            catch (CosClientException e) {
                throw e;
            }
            for (PartSummary partSummary : partListing.getParts()) {
                partETags.add(new PartETag(partSummary.getPartNumber(), partSummary.getETag()));
            }
            listPartsRequest.setPartNumberMarker(partListing.getNextPartNumberMarker());
        } while (partListing.isTruncated());
        cosclient.shutdown();
        return partETags;
    }

    public static List<PartETag> UploadPartDemo(String uploadId) {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "test-xxx";
        String key = "aaa/bbb.txt";
        LinkedList<PartETag> partETags = new LinkedList<PartETag>();
        for (int i = 0; i < 10; ++i) {
            byte[] data = new byte[0x100000];
            UploadPartRequest uploadPartRequest = new UploadPartRequest();
            uploadPartRequest.setBucketName(bucketName);
            uploadPartRequest.setKey(key);
            uploadPartRequest.setUploadId(uploadId);
            uploadPartRequest.setInputStream(new ByteArrayInputStream(data));
            uploadPartRequest.setPartSize(data.length);
            uploadPartRequest.setPartNumber(i + 1);
            try {
                UploadPartResult uploadPartResult = cosclient.uploadPart(uploadPartRequest);
                PartETag partETag = uploadPartResult.getPartETag();
                partETags.add(partETag);
                continue;
            }
            catch (CosServiceException e) {
                throw e;
            }
            catch (CosClientException e) {
                throw e;
            }
        }
        cosclient.shutdown();
        return partETags;
    }

    public static void completePartDemo(String uploadId, List<PartETag> partETags) {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "test-xxx";
        String key = "aaa/bbb.txt";
        CompleteMultipartUploadRequest completeMultipartUploadRequest = new CompleteMultipartUploadRequest(bucketName, key, uploadId, partETags);
        try {
            CompleteMultipartUploadResult completeResult = cosclient.completeMultipartUpload(completeMultipartUploadRequest);
            String string = completeResult.getETag();
        }
        catch (CosServiceException e) {
            throw e;
        }
        catch (CosClientException e) {
            throw e;
        }
        cosclient.shutdown();
    }

    public static void abortPartUploadDemo(String uploadId) {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "test-xxx";
        String key = "aaa/bbb.txt";
        AbortMultipartUploadRequest abortMultipartUploadRequest = new AbortMultipartUploadRequest(bucketName, key, uploadId);
        try {
            cosclient.abortMultipartUpload(abortMultipartUploadRequest);
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        cosclient.shutdown();
    }

    public static void copyPartUploadDemo(String uploadId) {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXX", "1A2Z3YYYYYYYYYY");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-guangzhou"));
        COSClient cosclient = new COSClient(cred, clientConfig);
        String bucketName = "test-xxx";
        String key = "aaa/bbb.txt";
        CopyPartRequest copyPartRequest = new CopyPartRequest();
        copyPartRequest.setSourceBucketRegion(new Region("ap-guangzhou"));
        copyPartRequest.setSourceBucketName(bucketName);
        copyPartRequest.setSourceKey("aaa/ccc.txt");
        copyPartRequest.setFirstByte(0L);
        copyPartRequest.setLastByte(1048575L);
        copyPartRequest.setDestinationBucketName(bucketName);
        copyPartRequest.setDestinationKey(key);
        copyPartRequest.setUploadId(uploadId);
        try {
            CopyPartResult copyPartResult = cosclient.copyPart(copyPartRequest);
            PartETag partETag = copyPartResult.getPartETag();
        }
        catch (CosServiceException e) {
            e.printStackTrace();
        }
        catch (CosClientException e) {
            e.printStackTrace();
        }
        cosclient.shutdown();
    }

    public static void main(String[] args) {
        String uploadId = MultipartUploadDemo.InitMultipartUploadDemo();
        List<PartETag> partETags = MultipartUploadDemo.UploadPartDemo(uploadId);
        MultipartUploadDemo.completePartDemo(uploadId, partETags);
    }
}

