/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo;

import com.qcloud.cos.COSEncryptionClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSStaticCredentialsProvider;
import com.qcloud.cos.http.HttpProtocol;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoMode;
import com.qcloud.cos.internal.crypto.CryptoStorageMode;
import com.qcloud.cos.internal.crypto.KMSEncryptionMaterials;
import com.qcloud.cos.internal.crypto.KMSEncryptionMaterialsProvider;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.region.Region;
import java.io.File;

public class KMSEncryptionClientDemo {
    public static void main(String[] args) throws Exception {
        BasicCOSCredentials cred = new BasicCOSCredentials("AKIDXXXXXXXXXXXXXXXX", "YYZZZZZZZZZZZZZZZZZ");
        ClientConfig clientConfig = new ClientConfig(new Region("ap-beijing-1"));
        clientConfig.setHttpProtocol(HttpProtocol.https);
        String cmk = "XXXXXXX";
        KMSEncryptionMaterials encryptionMaterials = new KMSEncryptionMaterials(cmk);
        CryptoConfiguration cryptoConf = new CryptoConfiguration(CryptoMode.AuthenticatedEncryption).withStorageMode(CryptoStorageMode.ObjectMetadata);
        COSEncryptionClient cosEncryptionClient = new COSEncryptionClient(new COSStaticCredentialsProvider(cred), new KMSEncryptionMaterialsProvider(encryptionMaterials), clientConfig, cryptoConf);
        String bucketName = "mybucket-1251668577";
        String key = "xxx/yyy/zzz.txt";
        File localFile = new File("src/test/resources/plain.txt");
        PutObjectRequest putObjectRequest = new PutObjectRequest(bucketName, key, localFile);
        cosEncryptionClient.putObject(putObjectRequest);
        GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
        File downloadFile = new File("src/test/resources/downPlain.txt");
        cosEncryptionClient.getObject(getObjectRequest, downloadFile);
        cosEncryptionClient.deleteObject(bucketName, key);
        cosEncryptionClient.shutdown();
    }
}

